package zio.aws.guardduty.model
import scala.jdk.CollectionConverters.*
sealed trait FilterAction {
  def unwrap: software.amazon.awssdk.services.guardduty.model.FilterAction
}
object FilterAction {
  def wrap(
      value: software.amazon.awssdk.services.guardduty.model.FilterAction
  ): zio.aws.guardduty.model.FilterAction = value match {
    case software.amazon.awssdk.services.guardduty.model.FilterAction.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.guardduty.model.FilterAction.NOOP =>
      val r = NOOP
      r
    case software.amazon.awssdk.services.guardduty.model.FilterAction.ARCHIVE =>
      val r = ARCHIVE
      r
  }
  case object unknownToSdkVersion extends zio.aws.guardduty.model.FilterAction {
    override def unwrap
        : software.amazon.awssdk.services.guardduty.model.FilterAction =
      software.amazon.awssdk.services.guardduty.model.FilterAction.UNKNOWN_TO_SDK_VERSION
  }
  case object NOOP extends zio.aws.guardduty.model.FilterAction {
    override def unwrap
        : software.amazon.awssdk.services.guardduty.model.FilterAction =
      software.amazon.awssdk.services.guardduty.model.FilterAction.NOOP
  }
  case object ARCHIVE extends zio.aws.guardduty.model.FilterAction {
    override def unwrap
        : software.amazon.awssdk.services.guardduty.model.FilterAction =
      software.amazon.awssdk.services.guardduty.model.FilterAction.ARCHIVE
  }
}
