package zio.aws.guardduty.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.guardduty.model.primitives.{LongValue, NonEmptyString}
import scala.jdk.CollectionConverters.*
final case class FilterCondition(
    equalsValue: Optional[NonEmptyString] = Optional.Absent,
    greaterThan: Optional[LongValue] = Optional.Absent,
    lessThan: Optional[LongValue] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.guardduty.model.FilterCondition = {
    import FilterCondition.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.guardduty.model.FilterCondition
      .builder()
      .optionallyWith(
        equalsValue.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.equalsValue)
      .optionallyWith(greaterThan.map(value => value: java.lang.Long))(
        _.greaterThan
      )
      .optionallyWith(lessThan.map(value => value: java.lang.Long))(_.lessThan)
      .build()
  }
  def asReadOnly: zio.aws.guardduty.model.FilterCondition.ReadOnly =
    zio.aws.guardduty.model.FilterCondition.wrap(buildAwsValue())
}
object FilterCondition {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.guardduty.model.FilterCondition
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.guardduty.model.FilterCondition =
      zio.aws.guardduty.model.FilterCondition(
        equalsValue.map(value => value),
        greaterThan.map(value => value),
        lessThan.map(value => value)
      )
    def equalsValue: Optional[NonEmptyString]
    def greaterThan: Optional[LongValue]
    def lessThan: Optional[LongValue]
    def getEqualsValue: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("equalsValue", equalsValue)
    def getGreaterThan: ZIO[Any, AwsError, LongValue] =
      AwsError.unwrapOptionField("greaterThan", greaterThan)
    def getLessThan: ZIO[Any, AwsError, LongValue] =
      AwsError.unwrapOptionField("lessThan", lessThan)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.guardduty.model.FilterCondition
  ) extends zio.aws.guardduty.model.FilterCondition.ReadOnly {
    override val equalsValue: Optional[NonEmptyString] = zio.aws.core.internal
      .optionalFromNullable(impl.equalsValue())
      .map(value => zio.aws.guardduty.model.primitives.NonEmptyString(value))
    override val greaterThan: Optional[LongValue] = zio.aws.core.internal
      .optionalFromNullable(impl.greaterThan())
      .map(value => value: LongValue)
    override val lessThan: Optional[LongValue] = zio.aws.core.internal
      .optionalFromNullable(impl.lessThan())
      .map(value => value: LongValue)
  }
  def wrap(
      impl: software.amazon.awssdk.services.guardduty.model.FilterCondition
  ): zio.aws.guardduty.model.FilterCondition.ReadOnly = new Wrapper(impl)
}
