package zio.aws.guardduty.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class FilterCriteria(
    filterCriterion: Optional[
      Iterable[zio.aws.guardduty.model.FilterCriterion]
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.guardduty.model.FilterCriteria = {
    import FilterCriteria.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.guardduty.model.FilterCriteria
      .builder()
      .optionallyWith(
        filterCriterion.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.filterCriterion)
      .build()
  }
  def asReadOnly: zio.aws.guardduty.model.FilterCriteria.ReadOnly =
    zio.aws.guardduty.model.FilterCriteria.wrap(buildAwsValue())
}
object FilterCriteria {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.guardduty.model.FilterCriteria
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.guardduty.model.FilterCriteria =
      zio.aws.guardduty.model.FilterCriteria(
        filterCriterion.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def filterCriterion
        : Optional[List[zio.aws.guardduty.model.FilterCriterion.ReadOnly]]
    def getFilterCriterion: ZIO[Any, AwsError, List[
      zio.aws.guardduty.model.FilterCriterion.ReadOnly
    ]] = AwsError.unwrapOptionField("filterCriterion", filterCriterion)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.guardduty.model.FilterCriteria
  ) extends zio.aws.guardduty.model.FilterCriteria.ReadOnly {
    override val filterCriterion
        : Optional[List[zio.aws.guardduty.model.FilterCriterion.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.filterCriterion())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.guardduty.model.FilterCriterion.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.guardduty.model.FilterCriteria
  ): zio.aws.guardduty.model.FilterCriteria.ReadOnly = new Wrapper(impl)
}
