package zio.aws.guardduty.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class FilterCriterion(
    criterionKey: Optional[zio.aws.guardduty.model.CriterionKey] =
      Optional.Absent,
    filterCondition: Optional[zio.aws.guardduty.model.FilterCondition] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.guardduty.model.FilterCriterion = {
    import FilterCriterion.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.guardduty.model.FilterCriterion
      .builder()
      .optionallyWith(criterionKey.map(value => value.unwrap))(_.criterionKey)
      .optionallyWith(filterCondition.map(value => value.buildAwsValue()))(
        _.filterCondition
      )
      .build()
  }
  def asReadOnly: zio.aws.guardduty.model.FilterCriterion.ReadOnly =
    zio.aws.guardduty.model.FilterCriterion.wrap(buildAwsValue())
}
object FilterCriterion {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.guardduty.model.FilterCriterion
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.guardduty.model.FilterCriterion =
      zio.aws.guardduty.model.FilterCriterion(
        criterionKey.map(value => value),
        filterCondition.map(value => value.asEditable)
      )
    def criterionKey: Optional[zio.aws.guardduty.model.CriterionKey]
    def filterCondition
        : Optional[zio.aws.guardduty.model.FilterCondition.ReadOnly]
    def getCriterionKey
        : ZIO[Any, AwsError, zio.aws.guardduty.model.CriterionKey] =
      AwsError.unwrapOptionField("criterionKey", criterionKey)
    def getFilterCondition
        : ZIO[Any, AwsError, zio.aws.guardduty.model.FilterCondition.ReadOnly] =
      AwsError.unwrapOptionField("filterCondition", filterCondition)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.guardduty.model.FilterCriterion
  ) extends zio.aws.guardduty.model.FilterCriterion.ReadOnly {
    override val criterionKey: Optional[zio.aws.guardduty.model.CriterionKey] =
      zio.aws.core.internal
        .optionalFromNullable(impl.criterionKey())
        .map(value => zio.aws.guardduty.model.CriterionKey.wrap(value))
    override val filterCondition
        : Optional[zio.aws.guardduty.model.FilterCondition.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.filterCondition())
        .map(value => zio.aws.guardduty.model.FilterCondition.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.guardduty.model.FilterCriterion
  ): zio.aws.guardduty.model.FilterCriterion.ReadOnly = new Wrapper(impl)
}
