package zio.aws.guardduty.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.guardduty.model.primitives.FindingType
import scala.jdk.CollectionConverters.*
final case class Finding(
    accountId: String,
    arn: String,
    confidence: Optional[Double] = Optional.Absent,
    createdAt: String,
    description: Optional[String] = Optional.Absent,
    id: String,
    partition: Optional[String] = Optional.Absent,
    region: String,
    resource: zio.aws.guardduty.model.Resource,
    schemaVersion: String,
    service: Optional[zio.aws.guardduty.model.Service] = Optional.Absent,
    severity: Double,
    title: Optional[String] = Optional.Absent,
    `type`: FindingType,
    updatedAt: String
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.guardduty.model.Finding = {
    import Finding.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.guardduty.model.Finding
      .builder()
      .accountId(accountId: java.lang.String)
      .arn(arn: java.lang.String)
      .optionallyWith(confidence.map(value => value: java.lang.Double))(
        _.confidence
      )
      .createdAt(createdAt: java.lang.String)
      .optionallyWith(description.map(value => value: java.lang.String))(
        _.description
      )
      .id(id: java.lang.String)
      .optionallyWith(partition.map(value => value: java.lang.String))(
        _.partition
      )
      .region(region: java.lang.String)
      .resource(resource.buildAwsValue())
      .schemaVersion(schemaVersion: java.lang.String)
      .optionallyWith(service.map(value => value.buildAwsValue()))(_.service)
      .severity(severity: java.lang.Double)
      .optionallyWith(title.map(value => value: java.lang.String))(_.title)
      .`type`(FindingType.unwrap(`type`): java.lang.String)
      .updatedAt(updatedAt: java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.guardduty.model.Finding.ReadOnly =
    zio.aws.guardduty.model.Finding.wrap(buildAwsValue())
}
object Finding {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.guardduty.model.Finding] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.guardduty.model.Finding =
      zio.aws.guardduty.model.Finding(
        accountId,
        arn,
        confidence.map(value => value),
        createdAt,
        description.map(value => value),
        id,
        partition.map(value => value),
        region,
        resource.asEditable,
        schemaVersion,
        service.map(value => value.asEditable),
        severity,
        title.map(value => value),
        `type`,
        updatedAt
      )
    def accountId: String
    def arn: String
    def confidence: Optional[Double]
    def createdAt: String
    def description: Optional[String]
    def id: String
    def partition: Optional[String]
    def region: String
    def resource: zio.aws.guardduty.model.Resource.ReadOnly
    def schemaVersion: String
    def service: Optional[zio.aws.guardduty.model.Service.ReadOnly]
    def severity: Double
    def title: Optional[String]
    def `type`: FindingType
    def updatedAt: String
    def getAccountId: ZIO[Any, Nothing, String] = ZIO.succeed(accountId)
    def getArn: ZIO[Any, Nothing, String] = ZIO.succeed(arn)
    def getConfidence: ZIO[Any, AwsError, Double] =
      AwsError.unwrapOptionField("confidence", confidence)
    def getCreatedAt: ZIO[Any, Nothing, String] = ZIO.succeed(createdAt)
    def getDescription: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("description", description)
    def getId: ZIO[Any, Nothing, String] = ZIO.succeed(id)
    def getPartition: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("partition", partition)
    def getRegion: ZIO[Any, Nothing, String] = ZIO.succeed(region)
    def getResource
        : ZIO[Any, Nothing, zio.aws.guardduty.model.Resource.ReadOnly] =
      ZIO.succeed(resource)
    def getSchemaVersion: ZIO[Any, Nothing, String] = ZIO.succeed(schemaVersion)
    def getService
        : ZIO[Any, AwsError, zio.aws.guardduty.model.Service.ReadOnly] =
      AwsError.unwrapOptionField("service", service)
    def getSeverity: ZIO[Any, Nothing, Double] = ZIO.succeed(severity)
    def getTitle: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("title", title)
    def getType: ZIO[Any, Nothing, FindingType] = ZIO.succeed(`type`)
    def getUpdatedAt: ZIO[Any, Nothing, String] = ZIO.succeed(updatedAt)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.guardduty.model.Finding
  ) extends zio.aws.guardduty.model.Finding.ReadOnly {
    override val accountId: String = impl.accountId(): String
    override val arn: String = impl.arn(): String
    override val confidence: Optional[Double] = zio.aws.core.internal
      .optionalFromNullable(impl.confidence())
      .map(value => value: Double)
    override val createdAt: String = impl.createdAt(): String
    override val description: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.description())
      .map(value => value: String)
    override val id: String = impl.id(): String
    override val partition: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.partition())
      .map(value => value: String)
    override val region: String = impl.region(): String
    override val resource: zio.aws.guardduty.model.Resource.ReadOnly =
      zio.aws.guardduty.model.Resource.wrap(impl.resource())
    override val schemaVersion: String = impl.schemaVersion(): String
    override val service: Optional[zio.aws.guardduty.model.Service.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.service())
        .map(value => zio.aws.guardduty.model.Service.wrap(value))
    override val severity: Double = impl.severity(): Double
    override val title: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.title())
      .map(value => value: String)
    override val `type`: FindingType =
      zio.aws.guardduty.model.primitives.FindingType(impl.`type`())
    override val updatedAt: String = impl.updatedAt(): String
  }
  def wrap(
      impl: software.amazon.awssdk.services.guardduty.model.Finding
  ): zio.aws.guardduty.model.Finding.ReadOnly = new Wrapper(impl)
}
