package zio.aws.guardduty.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class FindingCriteria(
    criterion: Optional[Map[String, zio.aws.guardduty.model.Condition]] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.guardduty.model.FindingCriteria = {
    import FindingCriteria.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.guardduty.model.FindingCriteria
      .builder()
      .optionallyWith(
        criterion.map(value =>
          value
            .map({ case (key, value) =>
              (key: java.lang.String) -> value.buildAwsValue()
            })
            .asJava
        )
      )(_.criterion)
      .build()
  }
  def asReadOnly: zio.aws.guardduty.model.FindingCriteria.ReadOnly =
    zio.aws.guardduty.model.FindingCriteria.wrap(buildAwsValue())
}
object FindingCriteria {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.guardduty.model.FindingCriteria
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.guardduty.model.FindingCriteria =
      zio.aws.guardduty.model.FindingCriteria(
        criterion.map(value =>
          value.map({ case (key, value) =>
            key -> value.asEditable
          })
        )
      )
    def criterion
        : Optional[Map[String, zio.aws.guardduty.model.Condition.ReadOnly]]
    def getCriterion: ZIO[Any, AwsError, Map[
      String,
      zio.aws.guardduty.model.Condition.ReadOnly
    ]] = AwsError.unwrapOptionField("criterion", criterion)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.guardduty.model.FindingCriteria
  ) extends zio.aws.guardduty.model.FindingCriteria.ReadOnly {
    override val criterion
        : Optional[Map[String, zio.aws.guardduty.model.Condition.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.criterion())
        .map(value =>
          value.asScala
            .map({ case (key, value) =>
              (key: String) -> zio.aws.guardduty.model.Condition.wrap(value)
            })
            .toMap
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.guardduty.model.FindingCriteria
  ): zio.aws.guardduty.model.FindingCriteria.ReadOnly = new Wrapper(impl)
}
