package zio.aws.guardduty.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.guardduty.model.primitives.Integer
import scala.jdk.CollectionConverters.*
final case class FindingStatistics(
    countBySeverity: Optional[Map[String, Integer]] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.guardduty.model.FindingStatistics = {
    import FindingStatistics.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.guardduty.model.FindingStatistics
      .builder()
      .optionallyWith(
        countBySeverity.map(value =>
          value
            .map({ case (key, value) =>
              (key: java.lang.String) -> (value: java.lang.Integer)
            })
            .asJava
        )
      )(_.countBySeverity)
      .build()
  }
  def asReadOnly: zio.aws.guardduty.model.FindingStatistics.ReadOnly =
    zio.aws.guardduty.model.FindingStatistics.wrap(buildAwsValue())
}
object FindingStatistics {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.guardduty.model.FindingStatistics
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.guardduty.model.FindingStatistics =
      zio.aws.guardduty.model
        .FindingStatistics(countBySeverity.map(value => value))
    def countBySeverity: Optional[Map[String, Integer]]
    def getCountBySeverity: ZIO[Any, AwsError, Map[String, Integer]] =
      AwsError.unwrapOptionField("countBySeverity", countBySeverity)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.guardduty.model.FindingStatistics
  ) extends zio.aws.guardduty.model.FindingStatistics.ReadOnly {
    override val countBySeverity: Optional[Map[String, Integer]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.countBySeverity())
        .map(value =>
          value.asScala
            .map({ case (key, value) =>
              (key: String) -> (value: Integer)
            })
            .toMap
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.guardduty.model.FindingStatistics
  ): zio.aws.guardduty.model.FindingStatistics.ReadOnly = new Wrapper(impl)
}
