package zio.aws.guardduty.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class FlowLogsConfigurationResult(
    status: zio.aws.guardduty.model.DataSourceStatus
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.guardduty.model.FlowLogsConfigurationResult = {
    import FlowLogsConfigurationResult.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.guardduty.model.FlowLogsConfigurationResult
      .builder()
      .status(status.unwrap)
      .build()
  }
  def asReadOnly: zio.aws.guardduty.model.FlowLogsConfigurationResult.ReadOnly =
    zio.aws.guardduty.model.FlowLogsConfigurationResult.wrap(buildAwsValue())
}
object FlowLogsConfigurationResult {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.guardduty.model.FlowLogsConfigurationResult
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.guardduty.model.FlowLogsConfigurationResult =
      zio.aws.guardduty.model.FlowLogsConfigurationResult(status)
    def status: zio.aws.guardduty.model.DataSourceStatus
    def getStatus: ZIO[Any, Nothing, zio.aws.guardduty.model.DataSourceStatus] =
      ZIO.succeed(status)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.guardduty.model.FlowLogsConfigurationResult
  ) extends zio.aws.guardduty.model.FlowLogsConfigurationResult.ReadOnly {
    override val status: zio.aws.guardduty.model.DataSourceStatus =
      zio.aws.guardduty.model.DataSourceStatus.wrap(impl.status())
  }
  def wrap(
      impl: software.amazon.awssdk.services.guardduty.model.FlowLogsConfigurationResult
  ): zio.aws.guardduty.model.FlowLogsConfigurationResult.ReadOnly = new Wrapper(
    impl
  )
}
