package zio.aws.guardduty.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class GeoLocation(
    lat: Optional[Double] = Optional.Absent,
    lon: Optional[Double] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.guardduty.model.GeoLocation = {
    import GeoLocation.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.guardduty.model.GeoLocation
      .builder()
      .optionallyWith(lat.map(value => value: java.lang.Double))(_.lat)
      .optionallyWith(lon.map(value => value: java.lang.Double))(_.lon)
      .build()
  }
  def asReadOnly: zio.aws.guardduty.model.GeoLocation.ReadOnly =
    zio.aws.guardduty.model.GeoLocation.wrap(buildAwsValue())
}
object GeoLocation {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.guardduty.model.GeoLocation
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.guardduty.model.GeoLocation =
      zio.aws.guardduty.model
        .GeoLocation(lat.map(value => value), lon.map(value => value))
    def lat: Optional[Double]
    def lon: Optional[Double]
    def getLat: ZIO[Any, AwsError, Double] =
      AwsError.unwrapOptionField("lat", lat)
    def getLon: ZIO[Any, AwsError, Double] =
      AwsError.unwrapOptionField("lon", lon)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.guardduty.model.GeoLocation
  ) extends zio.aws.guardduty.model.GeoLocation.ReadOnly {
    override val lat: Optional[Double] = zio.aws.core.internal
      .optionalFromNullable(impl.lat())
      .map(value => value: Double)
    override val lon: Optional[Double] = zio.aws.core.internal
      .optionalFromNullable(impl.lon())
      .map(value => value: Double)
  }
  def wrap(
      impl: software.amazon.awssdk.services.guardduty.model.GeoLocation
  ): zio.aws.guardduty.model.GeoLocation.ReadOnly = new Wrapper(impl)
}
