package zio.aws.guardduty.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.guardduty.model.primitives.DetectorId
import scala.jdk.CollectionConverters.*
final case class GetAdministratorAccountRequest(detectorId: DetectorId) {
  def buildAwsValue()
      : software.amazon.awssdk.services.guardduty.model.GetAdministratorAccountRequest = {
    import GetAdministratorAccountRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.guardduty.model.GetAdministratorAccountRequest
      .builder()
      .detectorId(DetectorId.unwrap(detectorId): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.guardduty.model.GetAdministratorAccountRequest.ReadOnly =
    zio.aws.guardduty.model.GetAdministratorAccountRequest.wrap(buildAwsValue())
}
object GetAdministratorAccountRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.guardduty.model.GetAdministratorAccountRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.guardduty.model.GetAdministratorAccountRequest =
      zio.aws.guardduty.model.GetAdministratorAccountRequest(detectorId)
    def detectorId: DetectorId
    def getDetectorId: ZIO[Any, Nothing, DetectorId] = ZIO.succeed(detectorId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.guardduty.model.GetAdministratorAccountRequest
  ) extends zio.aws.guardduty.model.GetAdministratorAccountRequest.ReadOnly {
    override val detectorId: DetectorId =
      zio.aws.guardduty.model.primitives.DetectorId(impl.detectorId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.guardduty.model.GetAdministratorAccountRequest
  ): zio.aws.guardduty.model.GetAdministratorAccountRequest.ReadOnly =
    new Wrapper(impl)
}
