package zio.aws.guardduty.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class GetAdministratorAccountResponse(
    administrator: zio.aws.guardduty.model.Administrator
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.guardduty.model.GetAdministratorAccountResponse = {
    import GetAdministratorAccountResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.guardduty.model.GetAdministratorAccountResponse
      .builder()
      .administrator(administrator.buildAwsValue())
      .build()
  }
  def asReadOnly
      : zio.aws.guardduty.model.GetAdministratorAccountResponse.ReadOnly =
    zio.aws.guardduty.model.GetAdministratorAccountResponse
      .wrap(buildAwsValue())
}
object GetAdministratorAccountResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.guardduty.model.GetAdministratorAccountResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.guardduty.model.GetAdministratorAccountResponse =
      zio.aws.guardduty.model
        .GetAdministratorAccountResponse(administrator.asEditable)
    def administrator: zio.aws.guardduty.model.Administrator.ReadOnly
    def getAdministrator
        : ZIO[Any, Nothing, zio.aws.guardduty.model.Administrator.ReadOnly] =
      ZIO.succeed(administrator)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.guardduty.model.GetAdministratorAccountResponse
  ) extends zio.aws.guardduty.model.GetAdministratorAccountResponse.ReadOnly {
    override val administrator: zio.aws.guardduty.model.Administrator.ReadOnly =
      zio.aws.guardduty.model.Administrator.wrap(impl.administrator())
  }
  def wrap(
      impl: software.amazon.awssdk.services.guardduty.model.GetAdministratorAccountResponse
  ): zio.aws.guardduty.model.GetAdministratorAccountResponse.ReadOnly =
    new Wrapper(impl)
}
