package zio.aws.guardduty.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.guardduty.model.primitives.DetectorId
import scala.jdk.CollectionConverters.*
final case class GetDetectorRequest(detectorId: DetectorId) {
  def buildAwsValue()
      : software.amazon.awssdk.services.guardduty.model.GetDetectorRequest = {
    import GetDetectorRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.guardduty.model.GetDetectorRequest
      .builder()
      .detectorId(DetectorId.unwrap(detectorId): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.guardduty.model.GetDetectorRequest.ReadOnly =
    zio.aws.guardduty.model.GetDetectorRequest.wrap(buildAwsValue())
}
object GetDetectorRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.guardduty.model.GetDetectorRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.guardduty.model.GetDetectorRequest =
      zio.aws.guardduty.model.GetDetectorRequest(detectorId)
    def detectorId: DetectorId
    def getDetectorId: ZIO[Any, Nothing, DetectorId] = ZIO.succeed(detectorId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.guardduty.model.GetDetectorRequest
  ) extends zio.aws.guardduty.model.GetDetectorRequest.ReadOnly {
    override val detectorId: DetectorId =
      zio.aws.guardduty.model.primitives.DetectorId(impl.detectorId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.guardduty.model.GetDetectorRequest
  ): zio.aws.guardduty.model.GetDetectorRequest.ReadOnly = new Wrapper(impl)
}
