package zio.aws.guardduty.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.guardduty.model.primitives.{TagValue, TagKey}
import scala.jdk.CollectionConverters.*
final case class GetDetectorResponse(
    createdAt: Optional[String] = Optional.Absent,
    findingPublishingFrequency: Optional[
      zio.aws.guardduty.model.FindingPublishingFrequency
    ] = Optional.Absent,
    serviceRole: String,
    status: zio.aws.guardduty.model.DetectorStatus,
    updatedAt: Optional[String] = Optional.Absent,
    dataSources: Optional[
      zio.aws.guardduty.model.DataSourceConfigurationsResult
    ] = Optional.Absent,
    tags: Optional[Map[TagKey, TagValue]] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.guardduty.model.GetDetectorResponse = {
    import GetDetectorResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.guardduty.model.GetDetectorResponse
      .builder()
      .optionallyWith(createdAt.map(value => value: java.lang.String))(
        _.createdAt
      )
      .optionallyWith(findingPublishingFrequency.map(value => value.unwrap))(
        _.findingPublishingFrequency
      )
      .serviceRole(serviceRole: java.lang.String)
      .status(status.unwrap)
      .optionallyWith(updatedAt.map(value => value: java.lang.String))(
        _.updatedAt
      )
      .optionallyWith(dataSources.map(value => value.buildAwsValue()))(
        _.dataSources
      )
      .optionallyWith(
        tags.map(value =>
          value
            .map({ case (key, value) =>
              (TagKey.unwrap(key): java.lang.String) -> (TagValue
                .unwrap(value): java.lang.String)
            })
            .asJava
        )
      )(_.tags)
      .build()
  }
  def asReadOnly: zio.aws.guardduty.model.GetDetectorResponse.ReadOnly =
    zio.aws.guardduty.model.GetDetectorResponse.wrap(buildAwsValue())
}
object GetDetectorResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.guardduty.model.GetDetectorResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.guardduty.model.GetDetectorResponse =
      zio.aws.guardduty.model.GetDetectorResponse(
        createdAt.map(value => value),
        findingPublishingFrequency.map(value => value),
        serviceRole,
        status,
        updatedAt.map(value => value),
        dataSources.map(value => value.asEditable),
        tags.map(value => value)
      )
    def createdAt: Optional[String]
    def findingPublishingFrequency
        : Optional[zio.aws.guardduty.model.FindingPublishingFrequency]
    def serviceRole: String
    def status: zio.aws.guardduty.model.DetectorStatus
    def updatedAt: Optional[String]
    def dataSources: Optional[
      zio.aws.guardduty.model.DataSourceConfigurationsResult.ReadOnly
    ]
    def tags: Optional[Map[TagKey, TagValue]]
    def getCreatedAt: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("createdAt", createdAt)
    def getFindingPublishingFrequency: ZIO[
      Any,
      AwsError,
      zio.aws.guardduty.model.FindingPublishingFrequency
    ] = AwsError.unwrapOptionField(
      "findingPublishingFrequency",
      findingPublishingFrequency
    )
    def getServiceRole: ZIO[Any, Nothing, String] = ZIO.succeed(serviceRole)
    def getStatus: ZIO[Any, Nothing, zio.aws.guardduty.model.DetectorStatus] =
      ZIO.succeed(status)
    def getUpdatedAt: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("updatedAt", updatedAt)
    def getDataSources: ZIO[
      Any,
      AwsError,
      zio.aws.guardduty.model.DataSourceConfigurationsResult.ReadOnly
    ] = AwsError.unwrapOptionField("dataSources", dataSources)
    def getTags: ZIO[Any, AwsError, Map[TagKey, TagValue]] =
      AwsError.unwrapOptionField("tags", tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.guardduty.model.GetDetectorResponse
  ) extends zio.aws.guardduty.model.GetDetectorResponse.ReadOnly {
    override val createdAt: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.createdAt())
      .map(value => value: String)
    override val findingPublishingFrequency
        : Optional[zio.aws.guardduty.model.FindingPublishingFrequency] =
      zio.aws.core.internal
        .optionalFromNullable(impl.findingPublishingFrequency())
        .map(value =>
          zio.aws.guardduty.model.FindingPublishingFrequency.wrap(value)
        )
    override val serviceRole: String = impl.serviceRole(): String
    override val status: zio.aws.guardduty.model.DetectorStatus =
      zio.aws.guardduty.model.DetectorStatus.wrap(impl.status())
    override val updatedAt: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.updatedAt())
      .map(value => value: String)
    override val dataSources: Optional[
      zio.aws.guardduty.model.DataSourceConfigurationsResult.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.dataSources())
      .map(value =>
        zio.aws.guardduty.model.DataSourceConfigurationsResult.wrap(value)
      )
    override val tags: Optional[Map[TagKey, TagValue]] = zio.aws.core.internal
      .optionalFromNullable(impl.tags())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            zio.aws.guardduty.model.primitives
              .TagKey(key) -> zio.aws.guardduty.model.primitives.TagValue(value)
          })
          .toMap
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.guardduty.model.GetDetectorResponse
  ): zio.aws.guardduty.model.GetDetectorResponse.ReadOnly = new Wrapper(impl)
}
