package zio.aws.guardduty.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.guardduty.model.primitives.DetectorId
import scala.jdk.CollectionConverters.*
final case class GetFilterRequest(detectorId: DetectorId, filterName: String) {
  def buildAwsValue()
      : software.amazon.awssdk.services.guardduty.model.GetFilterRequest = {
    import GetFilterRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.guardduty.model.GetFilterRequest
      .builder()
      .detectorId(DetectorId.unwrap(detectorId): java.lang.String)
      .filterName(filterName: java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.guardduty.model.GetFilterRequest.ReadOnly =
    zio.aws.guardduty.model.GetFilterRequest.wrap(buildAwsValue())
}
object GetFilterRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.guardduty.model.GetFilterRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.guardduty.model.GetFilterRequest =
      zio.aws.guardduty.model.GetFilterRequest(detectorId, filterName)
    def detectorId: DetectorId
    def filterName: String
    def getDetectorId: ZIO[Any, Nothing, DetectorId] = ZIO.succeed(detectorId)
    def getFilterName: ZIO[Any, Nothing, String] = ZIO.succeed(filterName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.guardduty.model.GetFilterRequest
  ) extends zio.aws.guardduty.model.GetFilterRequest.ReadOnly {
    override val detectorId: DetectorId =
      zio.aws.guardduty.model.primitives.DetectorId(impl.detectorId())
    override val filterName: String = impl.filterName(): String
  }
  def wrap(
      impl: software.amazon.awssdk.services.guardduty.model.GetFilterRequest
  ): zio.aws.guardduty.model.GetFilterRequest.ReadOnly = new Wrapper(impl)
}
