package zio.aws.guardduty.model
import zio.aws.guardduty.model.primitives.{
  FilterName,
  FilterDescription,
  TagValue,
  FilterRank,
  TagKey
}
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters.*
final case class GetFilterResponse(
    name: FilterName,
    description: Optional[FilterDescription] = Optional.Absent,
    action: zio.aws.guardduty.model.FilterAction,
    rank: Optional[FilterRank] = Optional.Absent,
    findingCriteria: zio.aws.guardduty.model.FindingCriteria,
    tags: Optional[Map[TagKey, TagValue]] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.guardduty.model.GetFilterResponse = {
    import GetFilterResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.guardduty.model.GetFilterResponse
      .builder()
      .name(FilterName.unwrap(name): java.lang.String)
      .optionallyWith(
        description.map(value =>
          FilterDescription.unwrap(value): java.lang.String
        )
      )(_.description)
      .action(action.unwrap)
      .optionallyWith(rank.map(value => FilterRank.unwrap(value): Integer))(
        _.rank
      )
      .findingCriteria(findingCriteria.buildAwsValue())
      .optionallyWith(
        tags.map(value =>
          value
            .map({ case (key, value) =>
              (TagKey.unwrap(key): java.lang.String) -> (TagValue
                .unwrap(value): java.lang.String)
            })
            .asJava
        )
      )(_.tags)
      .build()
  }
  def asReadOnly: zio.aws.guardduty.model.GetFilterResponse.ReadOnly =
    zio.aws.guardduty.model.GetFilterResponse.wrap(buildAwsValue())
}
object GetFilterResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.guardduty.model.GetFilterResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.guardduty.model.GetFilterResponse =
      zio.aws.guardduty.model.GetFilterResponse(
        name,
        description.map(value => value),
        action,
        rank.map(value => value),
        findingCriteria.asEditable,
        tags.map(value => value)
      )
    def name: FilterName
    def description: Optional[FilterDescription]
    def action: zio.aws.guardduty.model.FilterAction
    def rank: Optional[FilterRank]
    def findingCriteria: zio.aws.guardduty.model.FindingCriteria.ReadOnly
    def tags: Optional[Map[TagKey, TagValue]]
    def getName: ZIO[Any, Nothing, FilterName] = ZIO.succeed(name)
    def getDescription: ZIO[Any, AwsError, FilterDescription] =
      AwsError.unwrapOptionField("description", description)
    def getAction: ZIO[Any, Nothing, zio.aws.guardduty.model.FilterAction] =
      ZIO.succeed(action)
    def getRank: ZIO[Any, AwsError, FilterRank] =
      AwsError.unwrapOptionField("rank", rank)
    def getFindingCriteria
        : ZIO[Any, Nothing, zio.aws.guardduty.model.FindingCriteria.ReadOnly] =
      ZIO.succeed(findingCriteria)
    def getTags: ZIO[Any, AwsError, Map[TagKey, TagValue]] =
      AwsError.unwrapOptionField("tags", tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.guardduty.model.GetFilterResponse
  ) extends zio.aws.guardduty.model.GetFilterResponse.ReadOnly {
    override val name: FilterName =
      zio.aws.guardduty.model.primitives.FilterName(impl.name())
    override val description: Optional[FilterDescription] =
      zio.aws.core.internal
        .optionalFromNullable(impl.description())
        .map(value =>
          zio.aws.guardduty.model.primitives.FilterDescription(value)
        )
    override val action: zio.aws.guardduty.model.FilterAction =
      zio.aws.guardduty.model.FilterAction.wrap(impl.action())
    override val rank: Optional[FilterRank] = zio.aws.core.internal
      .optionalFromNullable(impl.rank())
      .map(value => zio.aws.guardduty.model.primitives.FilterRank(value))
    override val findingCriteria
        : zio.aws.guardduty.model.FindingCriteria.ReadOnly =
      zio.aws.guardduty.model.FindingCriteria.wrap(impl.findingCriteria())
    override val tags: Optional[Map[TagKey, TagValue]] = zio.aws.core.internal
      .optionalFromNullable(impl.tags())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            zio.aws.guardduty.model.primitives
              .TagKey(key) -> zio.aws.guardduty.model.primitives.TagValue(value)
          })
          .toMap
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.guardduty.model.GetFilterResponse
  ): zio.aws.guardduty.model.GetFilterResponse.ReadOnly = new Wrapper(impl)
}
