package zio.aws.guardduty.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.guardduty.model.primitives.{FindingId, DetectorId}
import scala.jdk.CollectionConverters.*
final case class GetFindingsRequest(
    detectorId: DetectorId,
    findingIds: Iterable[FindingId],
    sortCriteria: Optional[zio.aws.guardduty.model.SortCriteria] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.guardduty.model.GetFindingsRequest = {
    import GetFindingsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.guardduty.model.GetFindingsRequest
      .builder()
      .detectorId(DetectorId.unwrap(detectorId): java.lang.String)
      .findingIds(findingIds.map { item =>
        FindingId.unwrap(item): java.lang.String
      }.asJavaCollection)
      .optionallyWith(sortCriteria.map(value => value.buildAwsValue()))(
        _.sortCriteria
      )
      .build()
  }
  def asReadOnly: zio.aws.guardduty.model.GetFindingsRequest.ReadOnly =
    zio.aws.guardduty.model.GetFindingsRequest.wrap(buildAwsValue())
}
object GetFindingsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.guardduty.model.GetFindingsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.guardduty.model.GetFindingsRequest =
      zio.aws.guardduty.model.GetFindingsRequest(
        detectorId,
        findingIds,
        sortCriteria.map(value => value.asEditable)
      )
    def detectorId: DetectorId
    def findingIds: List[FindingId]
    def sortCriteria: Optional[zio.aws.guardduty.model.SortCriteria.ReadOnly]
    def getDetectorId: ZIO[Any, Nothing, DetectorId] = ZIO.succeed(detectorId)
    def getFindingIds: ZIO[Any, Nothing, List[FindingId]] =
      ZIO.succeed(findingIds)
    def getSortCriteria
        : ZIO[Any, AwsError, zio.aws.guardduty.model.SortCriteria.ReadOnly] =
      AwsError.unwrapOptionField("sortCriteria", sortCriteria)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.guardduty.model.GetFindingsRequest
  ) extends zio.aws.guardduty.model.GetFindingsRequest.ReadOnly {
    override val detectorId: DetectorId =
      zio.aws.guardduty.model.primitives.DetectorId(impl.detectorId())
    override val findingIds: List[FindingId] = impl
      .findingIds()
      .asScala
      .map { item =>
        zio.aws.guardduty.model.primitives.FindingId(item)
      }
      .toList
    override val sortCriteria
        : Optional[zio.aws.guardduty.model.SortCriteria.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.sortCriteria())
        .map(value => zio.aws.guardduty.model.SortCriteria.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.guardduty.model.GetFindingsRequest
  ): zio.aws.guardduty.model.GetFindingsRequest.ReadOnly = new Wrapper(impl)
}
