package zio.aws.guardduty.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class GetFindingsResponse(
    findings: Iterable[zio.aws.guardduty.model.Finding]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.guardduty.model.GetFindingsResponse = {
    import GetFindingsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.guardduty.model.GetFindingsResponse
      .builder()
      .findings(findings.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .build()
  }
  def asReadOnly: zio.aws.guardduty.model.GetFindingsResponse.ReadOnly =
    zio.aws.guardduty.model.GetFindingsResponse.wrap(buildAwsValue())
}
object GetFindingsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.guardduty.model.GetFindingsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.guardduty.model.GetFindingsResponse =
      zio.aws.guardduty.model.GetFindingsResponse(findings.map { item =>
        item.asEditable
      })
    def findings: List[zio.aws.guardduty.model.Finding.ReadOnly]
    def getFindings
        : ZIO[Any, Nothing, List[zio.aws.guardduty.model.Finding.ReadOnly]] =
      ZIO.succeed(findings)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.guardduty.model.GetFindingsResponse
  ) extends zio.aws.guardduty.model.GetFindingsResponse.ReadOnly {
    override val findings: List[zio.aws.guardduty.model.Finding.ReadOnly] = impl
      .findings()
      .asScala
      .map { item =>
        zio.aws.guardduty.model.Finding.wrap(item)
      }
      .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.guardduty.model.GetFindingsResponse
  ): zio.aws.guardduty.model.GetFindingsResponse.ReadOnly = new Wrapper(impl)
}
