package zio.aws.guardduty.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.guardduty.model.primitives.DetectorId
import scala.jdk.CollectionConverters.*
final case class GetFindingsStatisticsRequest(
    detectorId: DetectorId,
    findingStatisticTypes: Iterable[
      zio.aws.guardduty.model.FindingStatisticType
    ],
    findingCriteria: Optional[zio.aws.guardduty.model.FindingCriteria] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.guardduty.model.GetFindingsStatisticsRequest = {
    import GetFindingsStatisticsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.guardduty.model.GetFindingsStatisticsRequest
      .builder()
      .detectorId(DetectorId.unwrap(detectorId): java.lang.String)
      .findingStatisticTypesWithStrings(findingStatisticTypes.map { item =>
        item.unwrap.toString
      }.asJavaCollection)
      .optionallyWith(findingCriteria.map(value => value.buildAwsValue()))(
        _.findingCriteria
      )
      .build()
  }
  def asReadOnly
      : zio.aws.guardduty.model.GetFindingsStatisticsRequest.ReadOnly =
    zio.aws.guardduty.model.GetFindingsStatisticsRequest.wrap(buildAwsValue())
}
object GetFindingsStatisticsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.guardduty.model.GetFindingsStatisticsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.guardduty.model.GetFindingsStatisticsRequest =
      zio.aws.guardduty.model.GetFindingsStatisticsRequest(
        detectorId,
        findingStatisticTypes,
        findingCriteria.map(value => value.asEditable)
      )
    def detectorId: DetectorId
    def findingStatisticTypes
        : List[zio.aws.guardduty.model.FindingStatisticType]
    def findingCriteria
        : Optional[zio.aws.guardduty.model.FindingCriteria.ReadOnly]
    def getDetectorId: ZIO[Any, Nothing, DetectorId] = ZIO.succeed(detectorId)
    def getFindingStatisticTypes: ZIO[Any, Nothing, List[
      zio.aws.guardduty.model.FindingStatisticType
    ]] = ZIO.succeed(findingStatisticTypes)
    def getFindingCriteria
        : ZIO[Any, AwsError, zio.aws.guardduty.model.FindingCriteria.ReadOnly] =
      AwsError.unwrapOptionField("findingCriteria", findingCriteria)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.guardduty.model.GetFindingsStatisticsRequest
  ) extends zio.aws.guardduty.model.GetFindingsStatisticsRequest.ReadOnly {
    override val detectorId: DetectorId =
      zio.aws.guardduty.model.primitives.DetectorId(impl.detectorId())
    override val findingStatisticTypes
        : List[zio.aws.guardduty.model.FindingStatisticType] = impl
      .findingStatisticTypes()
      .asScala
      .map { item =>
        zio.aws.guardduty.model.FindingStatisticType.wrap(item)
      }
      .toList
    override val findingCriteria
        : Optional[zio.aws.guardduty.model.FindingCriteria.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.findingCriteria())
        .map(value => zio.aws.guardduty.model.FindingCriteria.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.guardduty.model.GetFindingsStatisticsRequest
  ): zio.aws.guardduty.model.GetFindingsStatisticsRequest.ReadOnly =
    new Wrapper(impl)
}
