package zio.aws.guardduty.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.guardduty.model.primitives.Integer
import scala.jdk.CollectionConverters.*
final case class GetInvitationsCountResponse(
    invitationsCount: Optional[Integer] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.guardduty.model.GetInvitationsCountResponse = {
    import GetInvitationsCountResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.guardduty.model.GetInvitationsCountResponse
      .builder()
      .optionallyWith(invitationsCount.map(value => value: java.lang.Integer))(
        _.invitationsCount
      )
      .build()
  }
  def asReadOnly: zio.aws.guardduty.model.GetInvitationsCountResponse.ReadOnly =
    zio.aws.guardduty.model.GetInvitationsCountResponse.wrap(buildAwsValue())
}
object GetInvitationsCountResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.guardduty.model.GetInvitationsCountResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.guardduty.model.GetInvitationsCountResponse =
      zio.aws.guardduty.model
        .GetInvitationsCountResponse(invitationsCount.map(value => value))
    def invitationsCount: Optional[Integer]
    def getInvitationsCount: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("invitationsCount", invitationsCount)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.guardduty.model.GetInvitationsCountResponse
  ) extends zio.aws.guardduty.model.GetInvitationsCountResponse.ReadOnly {
    override val invitationsCount: Optional[Integer] = zio.aws.core.internal
      .optionalFromNullable(impl.invitationsCount())
      .map(value => value: Integer)
  }
  def wrap(
      impl: software.amazon.awssdk.services.guardduty.model.GetInvitationsCountResponse
  ): zio.aws.guardduty.model.GetInvitationsCountResponse.ReadOnly = new Wrapper(
    impl
  )
}
