package zio.aws.guardduty.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.guardduty.model.primitives.{TagValue, TagKey, Location, Name}
import scala.jdk.CollectionConverters.*
final case class GetIpSetResponse(
    name: Name,
    format: zio.aws.guardduty.model.IpSetFormat,
    location: Location,
    status: zio.aws.guardduty.model.IpSetStatus,
    tags: Optional[Map[TagKey, TagValue]] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.guardduty.model.GetIpSetResponse = {
    import GetIpSetResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.guardduty.model.GetIpSetResponse
      .builder()
      .name(Name.unwrap(name): java.lang.String)
      .format(format.unwrap)
      .location(Location.unwrap(location): java.lang.String)
      .status(status.unwrap)
      .optionallyWith(
        tags.map(value =>
          value
            .map({ case (key, value) =>
              (TagKey.unwrap(key): java.lang.String) -> (TagValue
                .unwrap(value): java.lang.String)
            })
            .asJava
        )
      )(_.tags)
      .build()
  }
  def asReadOnly: zio.aws.guardduty.model.GetIpSetResponse.ReadOnly =
    zio.aws.guardduty.model.GetIpSetResponse.wrap(buildAwsValue())
}
object GetIpSetResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.guardduty.model.GetIpSetResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.guardduty.model.GetIpSetResponse =
      zio.aws.guardduty.model.GetIpSetResponse(
        name,
        format,
        location,
        status,
        tags.map(value => value)
      )
    def name: Name
    def format: zio.aws.guardduty.model.IpSetFormat
    def location: Location
    def status: zio.aws.guardduty.model.IpSetStatus
    def tags: Optional[Map[TagKey, TagValue]]
    def getName: ZIO[Any, Nothing, Name] = ZIO.succeed(name)
    def getFormat: ZIO[Any, Nothing, zio.aws.guardduty.model.IpSetFormat] =
      ZIO.succeed(format)
    def getLocation: ZIO[Any, Nothing, Location] = ZIO.succeed(location)
    def getStatus: ZIO[Any, Nothing, zio.aws.guardduty.model.IpSetStatus] =
      ZIO.succeed(status)
    def getTags: ZIO[Any, AwsError, Map[TagKey, TagValue]] =
      AwsError.unwrapOptionField("tags", tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.guardduty.model.GetIpSetResponse
  ) extends zio.aws.guardduty.model.GetIpSetResponse.ReadOnly {
    override val name: Name =
      zio.aws.guardduty.model.primitives.Name(impl.name())
    override val format: zio.aws.guardduty.model.IpSetFormat =
      zio.aws.guardduty.model.IpSetFormat.wrap(impl.format())
    override val location: Location =
      zio.aws.guardduty.model.primitives.Location(impl.location())
    override val status: zio.aws.guardduty.model.IpSetStatus =
      zio.aws.guardduty.model.IpSetStatus.wrap(impl.status())
    override val tags: Optional[Map[TagKey, TagValue]] = zio.aws.core.internal
      .optionalFromNullable(impl.tags())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            zio.aws.guardduty.model.primitives
              .TagKey(key) -> zio.aws.guardduty.model.primitives.TagValue(value)
          })
          .toMap
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.guardduty.model.GetIpSetResponse
  ): zio.aws.guardduty.model.GetIpSetResponse.ReadOnly = new Wrapper(impl)
}
