package zio.aws.guardduty.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.guardduty.model.primitives.DetectorId
import scala.jdk.CollectionConverters.*
final case class GetMalwareScanSettingsRequest(detectorId: DetectorId) {
  def buildAwsValue()
      : software.amazon.awssdk.services.guardduty.model.GetMalwareScanSettingsRequest = {
    import GetMalwareScanSettingsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.guardduty.model.GetMalwareScanSettingsRequest
      .builder()
      .detectorId(DetectorId.unwrap(detectorId): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.guardduty.model.GetMalwareScanSettingsRequest.ReadOnly =
    zio.aws.guardduty.model.GetMalwareScanSettingsRequest.wrap(buildAwsValue())
}
object GetMalwareScanSettingsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.guardduty.model.GetMalwareScanSettingsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.guardduty.model.GetMalwareScanSettingsRequest =
      zio.aws.guardduty.model.GetMalwareScanSettingsRequest(detectorId)
    def detectorId: DetectorId
    def getDetectorId: ZIO[Any, Nothing, DetectorId] = ZIO.succeed(detectorId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.guardduty.model.GetMalwareScanSettingsRequest
  ) extends zio.aws.guardduty.model.GetMalwareScanSettingsRequest.ReadOnly {
    override val detectorId: DetectorId =
      zio.aws.guardduty.model.primitives.DetectorId(impl.detectorId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.guardduty.model.GetMalwareScanSettingsRequest
  ): zio.aws.guardduty.model.GetMalwareScanSettingsRequest.ReadOnly =
    new Wrapper(impl)
}
