package zio.aws.guardduty.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class GetMalwareScanSettingsResponse(
    scanResourceCriteria: Optional[
      zio.aws.guardduty.model.ScanResourceCriteria
    ] = Optional.Absent,
    ebsSnapshotPreservation: Optional[
      zio.aws.guardduty.model.EbsSnapshotPreservation
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.guardduty.model.GetMalwareScanSettingsResponse = {
    import GetMalwareScanSettingsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.guardduty.model.GetMalwareScanSettingsResponse
      .builder()
      .optionallyWith(scanResourceCriteria.map(value => value.buildAwsValue()))(
        _.scanResourceCriteria
      )
      .optionallyWith(ebsSnapshotPreservation.map(value => value.unwrap))(
        _.ebsSnapshotPreservation
      )
      .build()
  }
  def asReadOnly
      : zio.aws.guardduty.model.GetMalwareScanSettingsResponse.ReadOnly =
    zio.aws.guardduty.model.GetMalwareScanSettingsResponse.wrap(buildAwsValue())
}
object GetMalwareScanSettingsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.guardduty.model.GetMalwareScanSettingsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.guardduty.model.GetMalwareScanSettingsResponse =
      zio.aws.guardduty.model.GetMalwareScanSettingsResponse(
        scanResourceCriteria.map(value => value.asEditable),
        ebsSnapshotPreservation.map(value => value)
      )
    def scanResourceCriteria
        : Optional[zio.aws.guardduty.model.ScanResourceCriteria.ReadOnly]
    def ebsSnapshotPreservation
        : Optional[zio.aws.guardduty.model.EbsSnapshotPreservation]
    def getScanResourceCriteria: ZIO[
      Any,
      AwsError,
      zio.aws.guardduty.model.ScanResourceCriteria.ReadOnly
    ] = AwsError.unwrapOptionField("scanResourceCriteria", scanResourceCriteria)
    def getEbsSnapshotPreservation
        : ZIO[Any, AwsError, zio.aws.guardduty.model.EbsSnapshotPreservation] =
      AwsError.unwrapOptionField(
        "ebsSnapshotPreservation",
        ebsSnapshotPreservation
      )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.guardduty.model.GetMalwareScanSettingsResponse
  ) extends zio.aws.guardduty.model.GetMalwareScanSettingsResponse.ReadOnly {
    override val scanResourceCriteria
        : Optional[zio.aws.guardduty.model.ScanResourceCriteria.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.scanResourceCriteria())
        .map(value => zio.aws.guardduty.model.ScanResourceCriteria.wrap(value))
    override val ebsSnapshotPreservation
        : Optional[zio.aws.guardduty.model.EbsSnapshotPreservation] =
      zio.aws.core.internal
        .optionalFromNullable(impl.ebsSnapshotPreservation())
        .map(value =>
          zio.aws.guardduty.model.EbsSnapshotPreservation.wrap(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.guardduty.model.GetMalwareScanSettingsResponse
  ): zio.aws.guardduty.model.GetMalwareScanSettingsResponse.ReadOnly =
    new Wrapper(impl)
}
