package zio.aws.guardduty.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.guardduty.model.primitives.{AccountId, DetectorId}
import scala.jdk.CollectionConverters.*
final case class GetMemberDetectorsRequest(
    detectorId: DetectorId,
    accountIds: Iterable[AccountId]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.guardduty.model.GetMemberDetectorsRequest = {
    import GetMemberDetectorsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.guardduty.model.GetMemberDetectorsRequest
      .builder()
      .detectorId(DetectorId.unwrap(detectorId): java.lang.String)
      .accountIds(accountIds.map { item =>
        AccountId.unwrap(item): java.lang.String
      }.asJavaCollection)
      .build()
  }
  def asReadOnly: zio.aws.guardduty.model.GetMemberDetectorsRequest.ReadOnly =
    zio.aws.guardduty.model.GetMemberDetectorsRequest.wrap(buildAwsValue())
}
object GetMemberDetectorsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.guardduty.model.GetMemberDetectorsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.guardduty.model.GetMemberDetectorsRequest =
      zio.aws.guardduty.model.GetMemberDetectorsRequest(detectorId, accountIds)
    def detectorId: DetectorId
    def accountIds: List[AccountId]
    def getDetectorId: ZIO[Any, Nothing, DetectorId] = ZIO.succeed(detectorId)
    def getAccountIds: ZIO[Any, Nothing, List[AccountId]] =
      ZIO.succeed(accountIds)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.guardduty.model.GetMemberDetectorsRequest
  ) extends zio.aws.guardduty.model.GetMemberDetectorsRequest.ReadOnly {
    override val detectorId: DetectorId =
      zio.aws.guardduty.model.primitives.DetectorId(impl.detectorId())
    override val accountIds: List[AccountId] = impl
      .accountIds()
      .asScala
      .map { item =>
        zio.aws.guardduty.model.primitives.AccountId(item)
      }
      .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.guardduty.model.GetMemberDetectorsRequest
  ): zio.aws.guardduty.model.GetMemberDetectorsRequest.ReadOnly = new Wrapper(
    impl
  )
}
