package zio.aws.guardduty.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class GetMemberDetectorsResponse(
    memberDataSourceConfigurations: Iterable[
      zio.aws.guardduty.model.MemberDataSourceConfiguration
    ],
    unprocessedAccounts: Iterable[zio.aws.guardduty.model.UnprocessedAccount]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.guardduty.model.GetMemberDetectorsResponse = {
    import GetMemberDetectorsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.guardduty.model.GetMemberDetectorsResponse
      .builder()
      .memberDataSourceConfigurations(memberDataSourceConfigurations.map {
        item =>
          item.buildAwsValue()
      }.asJavaCollection)
      .unprocessedAccounts(unprocessedAccounts.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .build()
  }
  def asReadOnly: zio.aws.guardduty.model.GetMemberDetectorsResponse.ReadOnly =
    zio.aws.guardduty.model.GetMemberDetectorsResponse.wrap(buildAwsValue())
}
object GetMemberDetectorsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.guardduty.model.GetMemberDetectorsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.guardduty.model.GetMemberDetectorsResponse =
      zio.aws.guardduty.model.GetMemberDetectorsResponse(
        memberDataSourceConfigurations.map { item =>
          item.asEditable
        },
        unprocessedAccounts.map { item =>
          item.asEditable
        }
      )
    def memberDataSourceConfigurations
        : List[zio.aws.guardduty.model.MemberDataSourceConfiguration.ReadOnly]
    def unprocessedAccounts
        : List[zio.aws.guardduty.model.UnprocessedAccount.ReadOnly]
    def getMemberDataSourceConfigurations: ZIO[Any, Nothing, List[
      zio.aws.guardduty.model.MemberDataSourceConfiguration.ReadOnly
    ]] = ZIO.succeed(memberDataSourceConfigurations)
    def getUnprocessedAccounts: ZIO[Any, Nothing, List[
      zio.aws.guardduty.model.UnprocessedAccount.ReadOnly
    ]] = ZIO.succeed(unprocessedAccounts)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.guardduty.model.GetMemberDetectorsResponse
  ) extends zio.aws.guardduty.model.GetMemberDetectorsResponse.ReadOnly {
    override val memberDataSourceConfigurations
        : List[zio.aws.guardduty.model.MemberDataSourceConfiguration.ReadOnly] =
      impl
        .memberDataSourceConfigurations()
        .asScala
        .map { item =>
          zio.aws.guardduty.model.MemberDataSourceConfiguration.wrap(item)
        }
        .toList
    override val unprocessedAccounts
        : List[zio.aws.guardduty.model.UnprocessedAccount.ReadOnly] = impl
      .unprocessedAccounts()
      .asScala
      .map { item =>
        zio.aws.guardduty.model.UnprocessedAccount.wrap(item)
      }
      .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.guardduty.model.GetMemberDetectorsResponse
  ): zio.aws.guardduty.model.GetMemberDetectorsResponse.ReadOnly = new Wrapper(
    impl
  )
}
