package zio.aws.guardduty.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class GetMembersResponse(
    members: Iterable[zio.aws.guardduty.model.Member],
    unprocessedAccounts: Iterable[zio.aws.guardduty.model.UnprocessedAccount]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.guardduty.model.GetMembersResponse = {
    import GetMembersResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.guardduty.model.GetMembersResponse
      .builder()
      .members(members.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .unprocessedAccounts(unprocessedAccounts.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .build()
  }
  def asReadOnly: zio.aws.guardduty.model.GetMembersResponse.ReadOnly =
    zio.aws.guardduty.model.GetMembersResponse.wrap(buildAwsValue())
}
object GetMembersResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.guardduty.model.GetMembersResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.guardduty.model.GetMembersResponse =
      zio.aws.guardduty.model.GetMembersResponse(
        members.map { item =>
          item.asEditable
        },
        unprocessedAccounts.map { item =>
          item.asEditable
        }
      )
    def members: List[zio.aws.guardduty.model.Member.ReadOnly]
    def unprocessedAccounts
        : List[zio.aws.guardduty.model.UnprocessedAccount.ReadOnly]
    def getMembers
        : ZIO[Any, Nothing, List[zio.aws.guardduty.model.Member.ReadOnly]] =
      ZIO.succeed(members)
    def getUnprocessedAccounts: ZIO[Any, Nothing, List[
      zio.aws.guardduty.model.UnprocessedAccount.ReadOnly
    ]] = ZIO.succeed(unprocessedAccounts)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.guardduty.model.GetMembersResponse
  ) extends zio.aws.guardduty.model.GetMembersResponse.ReadOnly {
    override val members: List[zio.aws.guardduty.model.Member.ReadOnly] = impl
      .members()
      .asScala
      .map { item =>
        zio.aws.guardduty.model.Member.wrap(item)
      }
      .toList
    override val unprocessedAccounts
        : List[zio.aws.guardduty.model.UnprocessedAccount.ReadOnly] = impl
      .unprocessedAccounts()
      .asScala
      .map { item =>
        zio.aws.guardduty.model.UnprocessedAccount.wrap(item)
      }
      .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.guardduty.model.GetMembersResponse
  ): zio.aws.guardduty.model.GetMembersResponse.ReadOnly = new Wrapper(impl)
}
