package zio.aws.guardduty.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.guardduty.model.primitives.{AccountId, DetectorId}
import scala.jdk.CollectionConverters.*
final case class GetRemainingFreeTrialDaysRequest(
    detectorId: DetectorId,
    accountIds: Optional[Iterable[AccountId]] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.guardduty.model.GetRemainingFreeTrialDaysRequest = {
    import GetRemainingFreeTrialDaysRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.guardduty.model.GetRemainingFreeTrialDaysRequest
      .builder()
      .detectorId(DetectorId.unwrap(detectorId): java.lang.String)
      .optionallyWith(
        accountIds.map(value =>
          value.map { item =>
            AccountId.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.accountIds)
      .build()
  }
  def asReadOnly
      : zio.aws.guardduty.model.GetRemainingFreeTrialDaysRequest.ReadOnly =
    zio.aws.guardduty.model.GetRemainingFreeTrialDaysRequest
      .wrap(buildAwsValue())
}
object GetRemainingFreeTrialDaysRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.guardduty.model.GetRemainingFreeTrialDaysRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.guardduty.model.GetRemainingFreeTrialDaysRequest =
      zio.aws.guardduty.model.GetRemainingFreeTrialDaysRequest(
        detectorId,
        accountIds.map(value => value)
      )
    def detectorId: DetectorId
    def accountIds: Optional[List[AccountId]]
    def getDetectorId: ZIO[Any, Nothing, DetectorId] = ZIO.succeed(detectorId)
    def getAccountIds: ZIO[Any, AwsError, List[AccountId]] =
      AwsError.unwrapOptionField("accountIds", accountIds)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.guardduty.model.GetRemainingFreeTrialDaysRequest
  ) extends zio.aws.guardduty.model.GetRemainingFreeTrialDaysRequest.ReadOnly {
    override val detectorId: DetectorId =
      zio.aws.guardduty.model.primitives.DetectorId(impl.detectorId())
    override val accountIds: Optional[List[AccountId]] = zio.aws.core.internal
      .optionalFromNullable(impl.accountIds())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.guardduty.model.primitives.AccountId(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.guardduty.model.GetRemainingFreeTrialDaysRequest
  ): zio.aws.guardduty.model.GetRemainingFreeTrialDaysRequest.ReadOnly =
    new Wrapper(impl)
}
