package zio.aws.guardduty.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class GetRemainingFreeTrialDaysResponse(
    accounts: Optional[Iterable[zio.aws.guardduty.model.AccountFreeTrialInfo]] =
      Optional.Absent,
    unprocessedAccounts: Optional[
      Iterable[zio.aws.guardduty.model.UnprocessedAccount]
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.guardduty.model.GetRemainingFreeTrialDaysResponse = {
    import GetRemainingFreeTrialDaysResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.guardduty.model.GetRemainingFreeTrialDaysResponse
      .builder()
      .optionallyWith(
        accounts.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.accounts)
      .optionallyWith(
        unprocessedAccounts.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.unprocessedAccounts)
      .build()
  }
  def asReadOnly
      : zio.aws.guardduty.model.GetRemainingFreeTrialDaysResponse.ReadOnly =
    zio.aws.guardduty.model.GetRemainingFreeTrialDaysResponse
      .wrap(buildAwsValue())
}
object GetRemainingFreeTrialDaysResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.guardduty.model.GetRemainingFreeTrialDaysResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.guardduty.model.GetRemainingFreeTrialDaysResponse =
      zio.aws.guardduty.model.GetRemainingFreeTrialDaysResponse(
        accounts.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        unprocessedAccounts.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def accounts
        : Optional[List[zio.aws.guardduty.model.AccountFreeTrialInfo.ReadOnly]]
    def unprocessedAccounts
        : Optional[List[zio.aws.guardduty.model.UnprocessedAccount.ReadOnly]]
    def getAccounts: ZIO[Any, AwsError, List[
      zio.aws.guardduty.model.AccountFreeTrialInfo.ReadOnly
    ]] = AwsError.unwrapOptionField("accounts", accounts)
    def getUnprocessedAccounts: ZIO[Any, AwsError, List[
      zio.aws.guardduty.model.UnprocessedAccount.ReadOnly
    ]] = AwsError.unwrapOptionField("unprocessedAccounts", unprocessedAccounts)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.guardduty.model.GetRemainingFreeTrialDaysResponse
  ) extends zio.aws.guardduty.model.GetRemainingFreeTrialDaysResponse.ReadOnly {
    override val accounts: Optional[
      List[zio.aws.guardduty.model.AccountFreeTrialInfo.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.accounts())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.guardduty.model.AccountFreeTrialInfo.wrap(item)
        }.toList
      )
    override val unprocessedAccounts
        : Optional[List[zio.aws.guardduty.model.UnprocessedAccount.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.unprocessedAccounts())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.guardduty.model.UnprocessedAccount.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.guardduty.model.GetRemainingFreeTrialDaysResponse
  ): zio.aws.guardduty.model.GetRemainingFreeTrialDaysResponse.ReadOnly =
    new Wrapper(impl)
}
