package zio.aws.guardduty.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.guardduty.model.primitives.DetectorId
import scala.jdk.CollectionConverters.*
final case class GetThreatIntelSetRequest(
    detectorId: DetectorId,
    threatIntelSetId: String
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.guardduty.model.GetThreatIntelSetRequest = {
    import GetThreatIntelSetRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.guardduty.model.GetThreatIntelSetRequest
      .builder()
      .detectorId(DetectorId.unwrap(detectorId): java.lang.String)
      .threatIntelSetId(threatIntelSetId: java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.guardduty.model.GetThreatIntelSetRequest.ReadOnly =
    zio.aws.guardduty.model.GetThreatIntelSetRequest.wrap(buildAwsValue())
}
object GetThreatIntelSetRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.guardduty.model.GetThreatIntelSetRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.guardduty.model.GetThreatIntelSetRequest =
      zio.aws.guardduty.model
        .GetThreatIntelSetRequest(detectorId, threatIntelSetId)
    def detectorId: DetectorId
    def threatIntelSetId: String
    def getDetectorId: ZIO[Any, Nothing, DetectorId] = ZIO.succeed(detectorId)
    def getThreatIntelSetId: ZIO[Any, Nothing, String] =
      ZIO.succeed(threatIntelSetId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.guardduty.model.GetThreatIntelSetRequest
  ) extends zio.aws.guardduty.model.GetThreatIntelSetRequest.ReadOnly {
    override val detectorId: DetectorId =
      zio.aws.guardduty.model.primitives.DetectorId(impl.detectorId())
    override val threatIntelSetId: String = impl.threatIntelSetId(): String
  }
  def wrap(
      impl: software.amazon.awssdk.services.guardduty.model.GetThreatIntelSetRequest
  ): zio.aws.guardduty.model.GetThreatIntelSetRequest.ReadOnly = new Wrapper(
    impl
  )
}
