package zio.aws.guardduty.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.guardduty.model.primitives.{TagValue, TagKey, Location, Name}
import scala.jdk.CollectionConverters.*
final case class GetThreatIntelSetResponse(
    name: Name,
    format: zio.aws.guardduty.model.ThreatIntelSetFormat,
    location: Location,
    status: zio.aws.guardduty.model.ThreatIntelSetStatus,
    tags: Optional[Map[TagKey, TagValue]] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.guardduty.model.GetThreatIntelSetResponse = {
    import GetThreatIntelSetResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.guardduty.model.GetThreatIntelSetResponse
      .builder()
      .name(Name.unwrap(name): java.lang.String)
      .format(format.unwrap)
      .location(Location.unwrap(location): java.lang.String)
      .status(status.unwrap)
      .optionallyWith(
        tags.map(value =>
          value
            .map({ case (key, value) =>
              (TagKey.unwrap(key): java.lang.String) -> (TagValue
                .unwrap(value): java.lang.String)
            })
            .asJava
        )
      )(_.tags)
      .build()
  }
  def asReadOnly: zio.aws.guardduty.model.GetThreatIntelSetResponse.ReadOnly =
    zio.aws.guardduty.model.GetThreatIntelSetResponse.wrap(buildAwsValue())
}
object GetThreatIntelSetResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.guardduty.model.GetThreatIntelSetResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.guardduty.model.GetThreatIntelSetResponse =
      zio.aws.guardduty.model.GetThreatIntelSetResponse(
        name,
        format,
        location,
        status,
        tags.map(value => value)
      )
    def name: Name
    def format: zio.aws.guardduty.model.ThreatIntelSetFormat
    def location: Location
    def status: zio.aws.guardduty.model.ThreatIntelSetStatus
    def tags: Optional[Map[TagKey, TagValue]]
    def getName: ZIO[Any, Nothing, Name] = ZIO.succeed(name)
    def getFormat
        : ZIO[Any, Nothing, zio.aws.guardduty.model.ThreatIntelSetFormat] =
      ZIO.succeed(format)
    def getLocation: ZIO[Any, Nothing, Location] = ZIO.succeed(location)
    def getStatus
        : ZIO[Any, Nothing, zio.aws.guardduty.model.ThreatIntelSetStatus] =
      ZIO.succeed(status)
    def getTags: ZIO[Any, AwsError, Map[TagKey, TagValue]] =
      AwsError.unwrapOptionField("tags", tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.guardduty.model.GetThreatIntelSetResponse
  ) extends zio.aws.guardduty.model.GetThreatIntelSetResponse.ReadOnly {
    override val name: Name =
      zio.aws.guardduty.model.primitives.Name(impl.name())
    override val format: zio.aws.guardduty.model.ThreatIntelSetFormat =
      zio.aws.guardduty.model.ThreatIntelSetFormat.wrap(impl.format())
    override val location: Location =
      zio.aws.guardduty.model.primitives.Location(impl.location())
    override val status: zio.aws.guardduty.model.ThreatIntelSetStatus =
      zio.aws.guardduty.model.ThreatIntelSetStatus.wrap(impl.status())
    override val tags: Optional[Map[TagKey, TagValue]] = zio.aws.core.internal
      .optionalFromNullable(impl.tags())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            zio.aws.guardduty.model.primitives
              .TagKey(key) -> zio.aws.guardduty.model.primitives.TagValue(value)
          })
          .toMap
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.guardduty.model.GetThreatIntelSetResponse
  ): zio.aws.guardduty.model.GetThreatIntelSetResponse.ReadOnly = new Wrapper(
    impl
  )
}
