package zio.aws.guardduty.model
import zio.aws.guardduty.model.primitives.{MaxResults, DetectorId}
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters.*
final case class GetUsageStatisticsRequest(
    detectorId: DetectorId,
    usageStatisticType: zio.aws.guardduty.model.UsageStatisticType,
    usageCriteria: zio.aws.guardduty.model.UsageCriteria,
    unit: Optional[String] = Optional.Absent,
    maxResults: Optional[MaxResults] = Optional.Absent,
    nextToken: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.guardduty.model.GetUsageStatisticsRequest = {
    import GetUsageStatisticsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.guardduty.model.GetUsageStatisticsRequest
      .builder()
      .detectorId(DetectorId.unwrap(detectorId): java.lang.String)
      .usageStatisticType(usageStatisticType.unwrap)
      .usageCriteria(usageCriteria.buildAwsValue())
      .optionallyWith(unit.map(value => value: java.lang.String))(_.unit)
      .optionallyWith(
        maxResults.map(value => MaxResults.unwrap(value): Integer)
      )(_.maxResults)
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .build()
  }
  def asReadOnly: zio.aws.guardduty.model.GetUsageStatisticsRequest.ReadOnly =
    zio.aws.guardduty.model.GetUsageStatisticsRequest.wrap(buildAwsValue())
}
object GetUsageStatisticsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.guardduty.model.GetUsageStatisticsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.guardduty.model.GetUsageStatisticsRequest =
      zio.aws.guardduty.model.GetUsageStatisticsRequest(
        detectorId,
        usageStatisticType,
        usageCriteria.asEditable,
        unit.map(value => value),
        maxResults.map(value => value),
        nextToken.map(value => value)
      )
    def detectorId: DetectorId
    def usageStatisticType: zio.aws.guardduty.model.UsageStatisticType
    def usageCriteria: zio.aws.guardduty.model.UsageCriteria.ReadOnly
    def unit: Optional[String]
    def maxResults: Optional[MaxResults]
    def nextToken: Optional[String]
    def getDetectorId: ZIO[Any, Nothing, DetectorId] = ZIO.succeed(detectorId)
    def getUsageStatisticType
        : ZIO[Any, Nothing, zio.aws.guardduty.model.UsageStatisticType] =
      ZIO.succeed(usageStatisticType)
    def getUsageCriteria
        : ZIO[Any, Nothing, zio.aws.guardduty.model.UsageCriteria.ReadOnly] =
      ZIO.succeed(usageCriteria)
    def getUnit: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("unit", unit)
    def getMaxResults: ZIO[Any, AwsError, MaxResults] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getNextToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.guardduty.model.GetUsageStatisticsRequest
  ) extends zio.aws.guardduty.model.GetUsageStatisticsRequest.ReadOnly {
    override val detectorId: DetectorId =
      zio.aws.guardduty.model.primitives.DetectorId(impl.detectorId())
    override val usageStatisticType
        : zio.aws.guardduty.model.UsageStatisticType =
      zio.aws.guardduty.model.UsageStatisticType.wrap(impl.usageStatisticType())
    override val usageCriteria: zio.aws.guardduty.model.UsageCriteria.ReadOnly =
      zio.aws.guardduty.model.UsageCriteria.wrap(impl.usageCriteria())
    override val unit: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.unit())
      .map(value => value: String)
    override val maxResults: Optional[MaxResults] = zio.aws.core.internal
      .optionalFromNullable(impl.maxResults())
      .map(value => zio.aws.guardduty.model.primitives.MaxResults(value))
    override val nextToken: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.guardduty.model.GetUsageStatisticsRequest
  ): zio.aws.guardduty.model.GetUsageStatisticsRequest.ReadOnly = new Wrapper(
    impl
  )
}
