package zio.aws.guardduty.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class GetUsageStatisticsResponse(
    usageStatistics: Optional[zio.aws.guardduty.model.UsageStatistics] =
      Optional.Absent,
    nextToken: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.guardduty.model.GetUsageStatisticsResponse = {
    import GetUsageStatisticsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.guardduty.model.GetUsageStatisticsResponse
      .builder()
      .optionallyWith(usageStatistics.map(value => value.buildAwsValue()))(
        _.usageStatistics
      )
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .build()
  }
  def asReadOnly: zio.aws.guardduty.model.GetUsageStatisticsResponse.ReadOnly =
    zio.aws.guardduty.model.GetUsageStatisticsResponse.wrap(buildAwsValue())
}
object GetUsageStatisticsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.guardduty.model.GetUsageStatisticsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.guardduty.model.GetUsageStatisticsResponse =
      zio.aws.guardduty.model.GetUsageStatisticsResponse(
        usageStatistics.map(value => value.asEditable),
        nextToken.map(value => value)
      )
    def usageStatistics
        : Optional[zio.aws.guardduty.model.UsageStatistics.ReadOnly]
    def nextToken: Optional[String]
    def getUsageStatistics
        : ZIO[Any, AwsError, zio.aws.guardduty.model.UsageStatistics.ReadOnly] =
      AwsError.unwrapOptionField("usageStatistics", usageStatistics)
    def getNextToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.guardduty.model.GetUsageStatisticsResponse
  ) extends zio.aws.guardduty.model.GetUsageStatisticsResponse.ReadOnly {
    override val usageStatistics
        : Optional[zio.aws.guardduty.model.UsageStatistics.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.usageStatistics())
        .map(value => zio.aws.guardduty.model.UsageStatistics.wrap(value))
    override val nextToken: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.guardduty.model.GetUsageStatisticsResponse
  ): zio.aws.guardduty.model.GetUsageStatisticsResponse.ReadOnly = new Wrapper(
    impl
  )
}
