package zio.aws.guardduty.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.guardduty.model.primitives.Integer
import scala.jdk.CollectionConverters.*
final case class HighestSeverityThreatDetails(
    severity: Optional[String] = Optional.Absent,
    threatName: Optional[String] = Optional.Absent,
    count: Optional[Integer] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.guardduty.model.HighestSeverityThreatDetails = {
    import HighestSeverityThreatDetails.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.guardduty.model.HighestSeverityThreatDetails
      .builder()
      .optionallyWith(severity.map(value => value: java.lang.String))(
        _.severity
      )
      .optionallyWith(threatName.map(value => value: java.lang.String))(
        _.threatName
      )
      .optionallyWith(count.map(value => value: java.lang.Integer))(_.count)
      .build()
  }
  def asReadOnly
      : zio.aws.guardduty.model.HighestSeverityThreatDetails.ReadOnly =
    zio.aws.guardduty.model.HighestSeverityThreatDetails.wrap(buildAwsValue())
}
object HighestSeverityThreatDetails {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.guardduty.model.HighestSeverityThreatDetails
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.guardduty.model.HighestSeverityThreatDetails =
      zio.aws.guardduty.model.HighestSeverityThreatDetails(
        severity.map(value => value),
        threatName.map(value => value),
        count.map(value => value)
      )
    def severity: Optional[String]
    def threatName: Optional[String]
    def count: Optional[Integer]
    def getSeverity: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("severity", severity)
    def getThreatName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("threatName", threatName)
    def getCount: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("count", count)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.guardduty.model.HighestSeverityThreatDetails
  ) extends zio.aws.guardduty.model.HighestSeverityThreatDetails.ReadOnly {
    override val severity: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.severity())
      .map(value => value: String)
    override val threatName: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.threatName())
      .map(value => value: String)
    override val count: Optional[Integer] = zio.aws.core.internal
      .optionalFromNullable(impl.count())
      .map(value => value: Integer)
  }
  def wrap(
      impl: software.amazon.awssdk.services.guardduty.model.HighestSeverityThreatDetails
  ): zio.aws.guardduty.model.HighestSeverityThreatDetails.ReadOnly =
    new Wrapper(impl)
}
