package zio.aws.guardduty.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class HostPath(path: Optional[String] = Optional.Absent) {
  def buildAwsValue()
      : software.amazon.awssdk.services.guardduty.model.HostPath = {
    import HostPath.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.guardduty.model.HostPath
      .builder()
      .optionallyWith(path.map(value => value: java.lang.String))(_.path)
      .build()
  }
  def asReadOnly: zio.aws.guardduty.model.HostPath.ReadOnly =
    zio.aws.guardduty.model.HostPath.wrap(buildAwsValue())
}
object HostPath {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.guardduty.model.HostPath
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.guardduty.model.HostPath =
      zio.aws.guardduty.model.HostPath(path.map(value => value))
    def path: Optional[String]
    def getPath: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("path", path)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.guardduty.model.HostPath
  ) extends zio.aws.guardduty.model.HostPath.ReadOnly {
    override val path: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.path())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.guardduty.model.HostPath
  ): zio.aws.guardduty.model.HostPath.ReadOnly = new Wrapper(impl)
}
