package zio.aws.guardduty.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class IamInstanceProfile(
    arn: Optional[String] = Optional.Absent,
    id: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.guardduty.model.IamInstanceProfile = {
    import IamInstanceProfile.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.guardduty.model.IamInstanceProfile
      .builder()
      .optionallyWith(arn.map(value => value: java.lang.String))(_.arn)
      .optionallyWith(id.map(value => value: java.lang.String))(_.id)
      .build()
  }
  def asReadOnly: zio.aws.guardduty.model.IamInstanceProfile.ReadOnly =
    zio.aws.guardduty.model.IamInstanceProfile.wrap(buildAwsValue())
}
object IamInstanceProfile {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.guardduty.model.IamInstanceProfile
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.guardduty.model.IamInstanceProfile =
      zio.aws.guardduty.model
        .IamInstanceProfile(arn.map(value => value), id.map(value => value))
    def arn: Optional[String]
    def id: Optional[String]
    def getArn: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("arn", arn)
    def getId: ZIO[Any, AwsError, String] = AwsError.unwrapOptionField("id", id)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.guardduty.model.IamInstanceProfile
  ) extends zio.aws.guardduty.model.IamInstanceProfile.ReadOnly {
    override val arn: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.arn())
      .map(value => value: String)
    override val id: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.id())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.guardduty.model.IamInstanceProfile
  ): zio.aws.guardduty.model.IamInstanceProfile.ReadOnly = new Wrapper(impl)
}
