package zio.aws.guardduty.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class InstanceDetails(
    availabilityZone: Optional[String] = Optional.Absent,
    iamInstanceProfile: Optional[zio.aws.guardduty.model.IamInstanceProfile] =
      Optional.Absent,
    imageDescription: Optional[String] = Optional.Absent,
    imageId: Optional[String] = Optional.Absent,
    instanceId: Optional[String] = Optional.Absent,
    instanceState: Optional[String] = Optional.Absent,
    instanceType: Optional[String] = Optional.Absent,
    outpostArn: Optional[String] = Optional.Absent,
    launchTime: Optional[String] = Optional.Absent,
    networkInterfaces: Optional[
      Iterable[zio.aws.guardduty.model.NetworkInterface]
    ] = Optional.Absent,
    platform: Optional[String] = Optional.Absent,
    productCodes: Optional[Iterable[zio.aws.guardduty.model.ProductCode]] =
      Optional.Absent,
    tags: Optional[Iterable[zio.aws.guardduty.model.Tag]] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.guardduty.model.InstanceDetails = {
    import InstanceDetails.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.guardduty.model.InstanceDetails
      .builder()
      .optionallyWith(availabilityZone.map(value => value: java.lang.String))(
        _.availabilityZone
      )
      .optionallyWith(iamInstanceProfile.map(value => value.buildAwsValue()))(
        _.iamInstanceProfile
      )
      .optionallyWith(imageDescription.map(value => value: java.lang.String))(
        _.imageDescription
      )
      .optionallyWith(imageId.map(value => value: java.lang.String))(_.imageId)
      .optionallyWith(instanceId.map(value => value: java.lang.String))(
        _.instanceId
      )
      .optionallyWith(instanceState.map(value => value: java.lang.String))(
        _.instanceState
      )
      .optionallyWith(instanceType.map(value => value: java.lang.String))(
        _.instanceType
      )
      .optionallyWith(outpostArn.map(value => value: java.lang.String))(
        _.outpostArn
      )
      .optionallyWith(launchTime.map(value => value: java.lang.String))(
        _.launchTime
      )
      .optionallyWith(
        networkInterfaces.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.networkInterfaces)
      .optionallyWith(platform.map(value => value: java.lang.String))(
        _.platform
      )
      .optionallyWith(
        productCodes.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.productCodes)
      .optionallyWith(
        tags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tags)
      .build()
  }
  def asReadOnly: zio.aws.guardduty.model.InstanceDetails.ReadOnly =
    zio.aws.guardduty.model.InstanceDetails.wrap(buildAwsValue())
}
object InstanceDetails {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.guardduty.model.InstanceDetails
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.guardduty.model.InstanceDetails =
      zio.aws.guardduty.model.InstanceDetails(
        availabilityZone.map(value => value),
        iamInstanceProfile.map(value => value.asEditable),
        imageDescription.map(value => value),
        imageId.map(value => value),
        instanceId.map(value => value),
        instanceState.map(value => value),
        instanceType.map(value => value),
        outpostArn.map(value => value),
        launchTime.map(value => value),
        networkInterfaces.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        platform.map(value => value),
        productCodes.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        tags.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def availabilityZone: Optional[String]
    def iamInstanceProfile
        : Optional[zio.aws.guardduty.model.IamInstanceProfile.ReadOnly]
    def imageDescription: Optional[String]
    def imageId: Optional[String]
    def instanceId: Optional[String]
    def instanceState: Optional[String]
    def instanceType: Optional[String]
    def outpostArn: Optional[String]
    def launchTime: Optional[String]
    def networkInterfaces
        : Optional[List[zio.aws.guardduty.model.NetworkInterface.ReadOnly]]
    def platform: Optional[String]
    def productCodes
        : Optional[List[zio.aws.guardduty.model.ProductCode.ReadOnly]]
    def tags: Optional[List[zio.aws.guardduty.model.Tag.ReadOnly]]
    def getAvailabilityZone: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("availabilityZone", availabilityZone)
    def getIamInstanceProfile: ZIO[
      Any,
      AwsError,
      zio.aws.guardduty.model.IamInstanceProfile.ReadOnly
    ] = AwsError.unwrapOptionField("iamInstanceProfile", iamInstanceProfile)
    def getImageDescription: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("imageDescription", imageDescription)
    def getImageId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("imageId", imageId)
    def getInstanceId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("instanceId", instanceId)
    def getInstanceState: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("instanceState", instanceState)
    def getInstanceType: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("instanceType", instanceType)
    def getOutpostArn: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("outpostArn", outpostArn)
    def getLaunchTime: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("launchTime", launchTime)
    def getNetworkInterfaces: ZIO[Any, AwsError, List[
      zio.aws.guardduty.model.NetworkInterface.ReadOnly
    ]] = AwsError.unwrapOptionField("networkInterfaces", networkInterfaces)
    def getPlatform: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("platform", platform)
    def getProductCodes: ZIO[Any, AwsError, List[
      zio.aws.guardduty.model.ProductCode.ReadOnly
    ]] = AwsError.unwrapOptionField("productCodes", productCodes)
    def getTags
        : ZIO[Any, AwsError, List[zio.aws.guardduty.model.Tag.ReadOnly]] =
      AwsError.unwrapOptionField("tags", tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.guardduty.model.InstanceDetails
  ) extends zio.aws.guardduty.model.InstanceDetails.ReadOnly {
    override val availabilityZone: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.availabilityZone())
      .map(value => value: String)
    override val iamInstanceProfile
        : Optional[zio.aws.guardduty.model.IamInstanceProfile.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.iamInstanceProfile())
        .map(value => zio.aws.guardduty.model.IamInstanceProfile.wrap(value))
    override val imageDescription: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.imageDescription())
      .map(value => value: String)
    override val imageId: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.imageId())
      .map(value => value: String)
    override val instanceId: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.instanceId())
      .map(value => value: String)
    override val instanceState: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.instanceState())
      .map(value => value: String)
    override val instanceType: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.instanceType())
      .map(value => value: String)
    override val outpostArn: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.outpostArn())
      .map(value => value: String)
    override val launchTime: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.launchTime())
      .map(value => value: String)
    override val networkInterfaces
        : Optional[List[zio.aws.guardduty.model.NetworkInterface.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.networkInterfaces())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.guardduty.model.NetworkInterface.wrap(item)
          }.toList
        )
    override val platform: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.platform())
      .map(value => value: String)
    override val productCodes
        : Optional[List[zio.aws.guardduty.model.ProductCode.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.productCodes())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.guardduty.model.ProductCode.wrap(item)
          }.toList
        )
    override val tags: Optional[List[zio.aws.guardduty.model.Tag.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.tags())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.guardduty.model.Tag.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.guardduty.model.InstanceDetails
  ): zio.aws.guardduty.model.InstanceDetails.ReadOnly = new Wrapper(impl)
}
