package zio.aws.guardduty.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.guardduty.model.primitives.{AccountId, DetectorId}
import scala.jdk.CollectionConverters.*
final case class InviteMembersRequest(
    detectorId: DetectorId,
    accountIds: Iterable[AccountId],
    disableEmailNotification: Optional[Boolean] = Optional.Absent,
    message: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.guardduty.model.InviteMembersRequest = {
    import InviteMembersRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.guardduty.model.InviteMembersRequest
      .builder()
      .detectorId(DetectorId.unwrap(detectorId): java.lang.String)
      .accountIds(accountIds.map { item =>
        AccountId.unwrap(item): java.lang.String
      }.asJavaCollection)
      .optionallyWith(
        disableEmailNotification.map(value => value: java.lang.Boolean)
      )(_.disableEmailNotification)
      .optionallyWith(message.map(value => value: java.lang.String))(_.message)
      .build()
  }
  def asReadOnly: zio.aws.guardduty.model.InviteMembersRequest.ReadOnly =
    zio.aws.guardduty.model.InviteMembersRequest.wrap(buildAwsValue())
}
object InviteMembersRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.guardduty.model.InviteMembersRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.guardduty.model.InviteMembersRequest =
      zio.aws.guardduty.model.InviteMembersRequest(
        detectorId,
        accountIds,
        disableEmailNotification.map(value => value),
        message.map(value => value)
      )
    def detectorId: DetectorId
    def accountIds: List[AccountId]
    def disableEmailNotification: Optional[Boolean]
    def message: Optional[String]
    def getDetectorId: ZIO[Any, Nothing, DetectorId] = ZIO.succeed(detectorId)
    def getAccountIds: ZIO[Any, Nothing, List[AccountId]] =
      ZIO.succeed(accountIds)
    def getDisableEmailNotification: ZIO[Any, AwsError, Boolean] = AwsError
      .unwrapOptionField("disableEmailNotification", disableEmailNotification)
    def getMessage: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("message", message)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.guardduty.model.InviteMembersRequest
  ) extends zio.aws.guardduty.model.InviteMembersRequest.ReadOnly {
    override val detectorId: DetectorId =
      zio.aws.guardduty.model.primitives.DetectorId(impl.detectorId())
    override val accountIds: List[AccountId] = impl
      .accountIds()
      .asScala
      .map { item =>
        zio.aws.guardduty.model.primitives.AccountId(item)
      }
      .toList
    override val disableEmailNotification: Optional[Boolean] =
      zio.aws.core.internal
        .optionalFromNullable(impl.disableEmailNotification())
        .map(value => value: Boolean)
    override val message: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.message())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.guardduty.model.InviteMembersRequest
  ): zio.aws.guardduty.model.InviteMembersRequest.ReadOnly = new Wrapper(impl)
}
