package zio.aws.guardduty.model
import scala.jdk.CollectionConverters.*
sealed trait IpSetFormat {
  def unwrap: software.amazon.awssdk.services.guardduty.model.IpSetFormat
}
object IpSetFormat {
  def wrap(
      value: software.amazon.awssdk.services.guardduty.model.IpSetFormat
  ): zio.aws.guardduty.model.IpSetFormat = value match {
    case software.amazon.awssdk.services.guardduty.model.IpSetFormat.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.guardduty.model.IpSetFormat.TXT =>
      val r = TXT
      r
    case software.amazon.awssdk.services.guardduty.model.IpSetFormat.STIX =>
      val r = STIX
      r
    case software.amazon.awssdk.services.guardduty.model.IpSetFormat.OTX_CSV =>
      val r = OTX_CSV
      r
    case software.amazon.awssdk.services.guardduty.model.IpSetFormat.ALIEN_VAULT =>
      val r = ALIEN_VAULT
      r
    case software.amazon.awssdk.services.guardduty.model.IpSetFormat.PROOF_POINT =>
      val r = PROOF_POINT
      r
    case software.amazon.awssdk.services.guardduty.model.IpSetFormat.FIRE_EYE =>
      val r = FIRE_EYE
      r
  }
  case object unknownToSdkVersion extends zio.aws.guardduty.model.IpSetFormat {
    override def unwrap
        : software.amazon.awssdk.services.guardduty.model.IpSetFormat =
      software.amazon.awssdk.services.guardduty.model.IpSetFormat.UNKNOWN_TO_SDK_VERSION
  }
  case object TXT extends zio.aws.guardduty.model.IpSetFormat {
    override def unwrap
        : software.amazon.awssdk.services.guardduty.model.IpSetFormat =
      software.amazon.awssdk.services.guardduty.model.IpSetFormat.TXT
  }
  case object STIX extends zio.aws.guardduty.model.IpSetFormat {
    override def unwrap
        : software.amazon.awssdk.services.guardduty.model.IpSetFormat =
      software.amazon.awssdk.services.guardduty.model.IpSetFormat.STIX
  }
  case object OTX_CSV extends zio.aws.guardduty.model.IpSetFormat {
    override def unwrap
        : software.amazon.awssdk.services.guardduty.model.IpSetFormat =
      software.amazon.awssdk.services.guardduty.model.IpSetFormat.OTX_CSV
  }
  case object ALIEN_VAULT extends zio.aws.guardduty.model.IpSetFormat {
    override def unwrap
        : software.amazon.awssdk.services.guardduty.model.IpSetFormat =
      software.amazon.awssdk.services.guardduty.model.IpSetFormat.ALIEN_VAULT
  }
  case object PROOF_POINT extends zio.aws.guardduty.model.IpSetFormat {
    override def unwrap
        : software.amazon.awssdk.services.guardduty.model.IpSetFormat =
      software.amazon.awssdk.services.guardduty.model.IpSetFormat.PROOF_POINT
  }
  case object FIRE_EYE extends zio.aws.guardduty.model.IpSetFormat {
    override def unwrap
        : software.amazon.awssdk.services.guardduty.model.IpSetFormat =
      software.amazon.awssdk.services.guardduty.model.IpSetFormat.FIRE_EYE
  }
}
