package zio.aws.guardduty.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.guardduty.model.primitives.Integer
import scala.jdk.CollectionConverters.*
final case class KubernetesApiCallAction(
    requestUri: Optional[String] = Optional.Absent,
    verb: Optional[String] = Optional.Absent,
    sourceIps: Optional[Iterable[String]] = Optional.Absent,
    userAgent: Optional[String] = Optional.Absent,
    remoteIpDetails: Optional[zio.aws.guardduty.model.RemoteIpDetails] =
      Optional.Absent,
    statusCode: Optional[Integer] = Optional.Absent,
    parameters: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.guardduty.model.KubernetesApiCallAction = {
    import KubernetesApiCallAction.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.guardduty.model.KubernetesApiCallAction
      .builder()
      .optionallyWith(requestUri.map(value => value: java.lang.String))(
        _.requestUri
      )
      .optionallyWith(verb.map(value => value: java.lang.String))(_.verb)
      .optionallyWith(
        sourceIps.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.sourceIps)
      .optionallyWith(userAgent.map(value => value: java.lang.String))(
        _.userAgent
      )
      .optionallyWith(remoteIpDetails.map(value => value.buildAwsValue()))(
        _.remoteIpDetails
      )
      .optionallyWith(statusCode.map(value => value: java.lang.Integer))(
        _.statusCode
      )
      .optionallyWith(parameters.map(value => value: java.lang.String))(
        _.parameters
      )
      .build()
  }
  def asReadOnly: zio.aws.guardduty.model.KubernetesApiCallAction.ReadOnly =
    zio.aws.guardduty.model.KubernetesApiCallAction.wrap(buildAwsValue())
}
object KubernetesApiCallAction {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.guardduty.model.KubernetesApiCallAction
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.guardduty.model.KubernetesApiCallAction =
      zio.aws.guardduty.model.KubernetesApiCallAction(
        requestUri.map(value => value),
        verb.map(value => value),
        sourceIps.map(value => value),
        userAgent.map(value => value),
        remoteIpDetails.map(value => value.asEditable),
        statusCode.map(value => value),
        parameters.map(value => value)
      )
    def requestUri: Optional[String]
    def verb: Optional[String]
    def sourceIps: Optional[List[String]]
    def userAgent: Optional[String]
    def remoteIpDetails
        : Optional[zio.aws.guardduty.model.RemoteIpDetails.ReadOnly]
    def statusCode: Optional[Integer]
    def parameters: Optional[String]
    def getRequestUri: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("requestUri", requestUri)
    def getVerb: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("verb", verb)
    def getSourceIps: ZIO[Any, AwsError, List[String]] =
      AwsError.unwrapOptionField("sourceIps", sourceIps)
    def getUserAgent: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("userAgent", userAgent)
    def getRemoteIpDetails
        : ZIO[Any, AwsError, zio.aws.guardduty.model.RemoteIpDetails.ReadOnly] =
      AwsError.unwrapOptionField("remoteIpDetails", remoteIpDetails)
    def getStatusCode: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("statusCode", statusCode)
    def getParameters: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("parameters", parameters)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.guardduty.model.KubernetesApiCallAction
  ) extends zio.aws.guardduty.model.KubernetesApiCallAction.ReadOnly {
    override val requestUri: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.requestUri())
      .map(value => value: String)
    override val verb: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.verb())
      .map(value => value: String)
    override val sourceIps: Optional[List[String]] = zio.aws.core.internal
      .optionalFromNullable(impl.sourceIps())
      .map(value =>
        value.asScala.map { item =>
          item: String
        }.toList
      )
    override val userAgent: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.userAgent())
      .map(value => value: String)
    override val remoteIpDetails
        : Optional[zio.aws.guardduty.model.RemoteIpDetails.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.remoteIpDetails())
        .map(value => zio.aws.guardduty.model.RemoteIpDetails.wrap(value))
    override val statusCode: Optional[Integer] = zio.aws.core.internal
      .optionalFromNullable(impl.statusCode())
      .map(value => value: Integer)
    override val parameters: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.parameters())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.guardduty.model.KubernetesApiCallAction
  ): zio.aws.guardduty.model.KubernetesApiCallAction.ReadOnly = new Wrapper(
    impl
  )
}
