package zio.aws.guardduty.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class KubernetesAuditLogsConfiguration(enable: Boolean) {
  def buildAwsValue()
      : software.amazon.awssdk.services.guardduty.model.KubernetesAuditLogsConfiguration = {
    import KubernetesAuditLogsConfiguration.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.guardduty.model.KubernetesAuditLogsConfiguration
      .builder()
      .enable(enable: java.lang.Boolean)
      .build()
  }
  def asReadOnly
      : zio.aws.guardduty.model.KubernetesAuditLogsConfiguration.ReadOnly =
    zio.aws.guardduty.model.KubernetesAuditLogsConfiguration
      .wrap(buildAwsValue())
}
object KubernetesAuditLogsConfiguration {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.guardduty.model.KubernetesAuditLogsConfiguration
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.guardduty.model.KubernetesAuditLogsConfiguration =
      zio.aws.guardduty.model.KubernetesAuditLogsConfiguration(enable)
    def enable: Boolean
    def getEnable: ZIO[Any, Nothing, Boolean] = ZIO.succeed(enable)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.guardduty.model.KubernetesAuditLogsConfiguration
  ) extends zio.aws.guardduty.model.KubernetesAuditLogsConfiguration.ReadOnly {
    override val enable: Boolean = impl.enable(): Boolean
  }
  def wrap(
      impl: software.amazon.awssdk.services.guardduty.model.KubernetesAuditLogsConfiguration
  ): zio.aws.guardduty.model.KubernetesAuditLogsConfiguration.ReadOnly =
    new Wrapper(impl)
}
