package zio.aws.guardduty.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class KubernetesAuditLogsConfigurationResult(
    status: zio.aws.guardduty.model.DataSourceStatus
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.guardduty.model.KubernetesAuditLogsConfigurationResult = {
    import KubernetesAuditLogsConfigurationResult.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.guardduty.model.KubernetesAuditLogsConfigurationResult
      .builder()
      .status(status.unwrap)
      .build()
  }
  def asReadOnly
      : zio.aws.guardduty.model.KubernetesAuditLogsConfigurationResult.ReadOnly =
    zio.aws.guardduty.model.KubernetesAuditLogsConfigurationResult
      .wrap(buildAwsValue())
}
object KubernetesAuditLogsConfigurationResult {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.guardduty.model.KubernetesAuditLogsConfigurationResult
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.guardduty.model.KubernetesAuditLogsConfigurationResult =
      zio.aws.guardduty.model.KubernetesAuditLogsConfigurationResult(status)
    def status: zio.aws.guardduty.model.DataSourceStatus
    def getStatus: ZIO[Any, Nothing, zio.aws.guardduty.model.DataSourceStatus] =
      ZIO.succeed(status)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.guardduty.model.KubernetesAuditLogsConfigurationResult
  ) extends zio.aws.guardduty.model.KubernetesAuditLogsConfigurationResult.ReadOnly {
    override val status: zio.aws.guardduty.model.DataSourceStatus =
      zio.aws.guardduty.model.DataSourceStatus.wrap(impl.status())
  }
  def wrap(
      impl: software.amazon.awssdk.services.guardduty.model.KubernetesAuditLogsConfigurationResult
  ): zio.aws.guardduty.model.KubernetesAuditLogsConfigurationResult.ReadOnly =
    new Wrapper(impl)
}
