package zio.aws.guardduty.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class KubernetesConfiguration(
    auditLogs: zio.aws.guardduty.model.KubernetesAuditLogsConfiguration
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.guardduty.model.KubernetesConfiguration = {
    import KubernetesConfiguration.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.guardduty.model.KubernetesConfiguration
      .builder()
      .auditLogs(auditLogs.buildAwsValue())
      .build()
  }
  def asReadOnly: zio.aws.guardduty.model.KubernetesConfiguration.ReadOnly =
    zio.aws.guardduty.model.KubernetesConfiguration.wrap(buildAwsValue())
}
object KubernetesConfiguration {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.guardduty.model.KubernetesConfiguration
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.guardduty.model.KubernetesConfiguration =
      zio.aws.guardduty.model.KubernetesConfiguration(auditLogs.asEditable)
    def auditLogs
        : zio.aws.guardduty.model.KubernetesAuditLogsConfiguration.ReadOnly
    def getAuditLogs: ZIO[
      Any,
      Nothing,
      zio.aws.guardduty.model.KubernetesAuditLogsConfiguration.ReadOnly
    ] = ZIO.succeed(auditLogs)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.guardduty.model.KubernetesConfiguration
  ) extends zio.aws.guardduty.model.KubernetesConfiguration.ReadOnly {
    override val auditLogs
        : zio.aws.guardduty.model.KubernetesAuditLogsConfiguration.ReadOnly =
      zio.aws.guardduty.model.KubernetesAuditLogsConfiguration
        .wrap(impl.auditLogs())
  }
  def wrap(
      impl: software.amazon.awssdk.services.guardduty.model.KubernetesConfiguration
  ): zio.aws.guardduty.model.KubernetesConfiguration.ReadOnly = new Wrapper(
    impl
  )
}
