package zio.aws.guardduty.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class KubernetesConfigurationResult(
    auditLogs: zio.aws.guardduty.model.KubernetesAuditLogsConfigurationResult
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.guardduty.model.KubernetesConfigurationResult = {
    import KubernetesConfigurationResult.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.guardduty.model.KubernetesConfigurationResult
      .builder()
      .auditLogs(auditLogs.buildAwsValue())
      .build()
  }
  def asReadOnly
      : zio.aws.guardduty.model.KubernetesConfigurationResult.ReadOnly =
    zio.aws.guardduty.model.KubernetesConfigurationResult.wrap(buildAwsValue())
}
object KubernetesConfigurationResult {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.guardduty.model.KubernetesConfigurationResult
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.guardduty.model.KubernetesConfigurationResult =
      zio.aws.guardduty.model
        .KubernetesConfigurationResult(auditLogs.asEditable)
    def auditLogs
        : zio.aws.guardduty.model.KubernetesAuditLogsConfigurationResult.ReadOnly
    def getAuditLogs: ZIO[
      Any,
      Nothing,
      zio.aws.guardduty.model.KubernetesAuditLogsConfigurationResult.ReadOnly
    ] = ZIO.succeed(auditLogs)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.guardduty.model.KubernetesConfigurationResult
  ) extends zio.aws.guardduty.model.KubernetesConfigurationResult.ReadOnly {
    override val auditLogs
        : zio.aws.guardduty.model.KubernetesAuditLogsConfigurationResult.ReadOnly =
      zio.aws.guardduty.model.KubernetesAuditLogsConfigurationResult
        .wrap(impl.auditLogs())
  }
  def wrap(
      impl: software.amazon.awssdk.services.guardduty.model.KubernetesConfigurationResult
  ): zio.aws.guardduty.model.KubernetesConfigurationResult.ReadOnly =
    new Wrapper(impl)
}
