package zio.aws.guardduty.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class KubernetesDataSourceFreeTrial(
    auditLogs: Optional[zio.aws.guardduty.model.DataSourceFreeTrial] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.guardduty.model.KubernetesDataSourceFreeTrial = {
    import KubernetesDataSourceFreeTrial.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.guardduty.model.KubernetesDataSourceFreeTrial
      .builder()
      .optionallyWith(auditLogs.map(value => value.buildAwsValue()))(
        _.auditLogs
      )
      .build()
  }
  def asReadOnly
      : zio.aws.guardduty.model.KubernetesDataSourceFreeTrial.ReadOnly =
    zio.aws.guardduty.model.KubernetesDataSourceFreeTrial.wrap(buildAwsValue())
}
object KubernetesDataSourceFreeTrial {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.guardduty.model.KubernetesDataSourceFreeTrial
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.guardduty.model.KubernetesDataSourceFreeTrial =
      zio.aws.guardduty.model
        .KubernetesDataSourceFreeTrial(auditLogs.map(value => value.asEditable))
    def auditLogs
        : Optional[zio.aws.guardduty.model.DataSourceFreeTrial.ReadOnly]
    def getAuditLogs: ZIO[
      Any,
      AwsError,
      zio.aws.guardduty.model.DataSourceFreeTrial.ReadOnly
    ] = AwsError.unwrapOptionField("auditLogs", auditLogs)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.guardduty.model.KubernetesDataSourceFreeTrial
  ) extends zio.aws.guardduty.model.KubernetesDataSourceFreeTrial.ReadOnly {
    override val auditLogs
        : Optional[zio.aws.guardduty.model.DataSourceFreeTrial.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.auditLogs())
        .map(value => zio.aws.guardduty.model.DataSourceFreeTrial.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.guardduty.model.KubernetesDataSourceFreeTrial
  ): zio.aws.guardduty.model.KubernetesDataSourceFreeTrial.ReadOnly =
    new Wrapper(impl)
}
