package zio.aws.guardduty.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class KubernetesDetails(
    kubernetesUserDetails: Optional[
      zio.aws.guardduty.model.KubernetesUserDetails
    ] = Optional.Absent,
    kubernetesWorkloadDetails: Optional[
      zio.aws.guardduty.model.KubernetesWorkloadDetails
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.guardduty.model.KubernetesDetails = {
    import KubernetesDetails.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.guardduty.model.KubernetesDetails
      .builder()
      .optionallyWith(
        kubernetesUserDetails.map(value => value.buildAwsValue())
      )(_.kubernetesUserDetails)
      .optionallyWith(
        kubernetesWorkloadDetails.map(value => value.buildAwsValue())
      )(_.kubernetesWorkloadDetails)
      .build()
  }
  def asReadOnly: zio.aws.guardduty.model.KubernetesDetails.ReadOnly =
    zio.aws.guardduty.model.KubernetesDetails.wrap(buildAwsValue())
}
object KubernetesDetails {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.guardduty.model.KubernetesDetails
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.guardduty.model.KubernetesDetails =
      zio.aws.guardduty.model.KubernetesDetails(
        kubernetesUserDetails.map(value => value.asEditable),
        kubernetesWorkloadDetails.map(value => value.asEditable)
      )
    def kubernetesUserDetails
        : Optional[zio.aws.guardduty.model.KubernetesUserDetails.ReadOnly]
    def kubernetesWorkloadDetails
        : Optional[zio.aws.guardduty.model.KubernetesWorkloadDetails.ReadOnly]
    def getKubernetesUserDetails: ZIO[
      Any,
      AwsError,
      zio.aws.guardduty.model.KubernetesUserDetails.ReadOnly
    ] =
      AwsError.unwrapOptionField("kubernetesUserDetails", kubernetesUserDetails)
    def getKubernetesWorkloadDetails: ZIO[
      Any,
      AwsError,
      zio.aws.guardduty.model.KubernetesWorkloadDetails.ReadOnly
    ] = AwsError.unwrapOptionField(
      "kubernetesWorkloadDetails",
      kubernetesWorkloadDetails
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.guardduty.model.KubernetesDetails
  ) extends zio.aws.guardduty.model.KubernetesDetails.ReadOnly {
    override val kubernetesUserDetails
        : Optional[zio.aws.guardduty.model.KubernetesUserDetails.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.kubernetesUserDetails())
        .map(value => zio.aws.guardduty.model.KubernetesUserDetails.wrap(value))
    override val kubernetesWorkloadDetails
        : Optional[zio.aws.guardduty.model.KubernetesWorkloadDetails.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.kubernetesWorkloadDetails())
        .map(value =>
          zio.aws.guardduty.model.KubernetesWorkloadDetails.wrap(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.guardduty.model.KubernetesDetails
  ): zio.aws.guardduty.model.KubernetesDetails.ReadOnly = new Wrapper(impl)
}
