package zio.aws.guardduty.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class KubernetesUserDetails(
    username: Optional[String] = Optional.Absent,
    uid: Optional[String] = Optional.Absent,
    groups: Optional[Iterable[String]] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.guardduty.model.KubernetesUserDetails = {
    import KubernetesUserDetails.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.guardduty.model.KubernetesUserDetails
      .builder()
      .optionallyWith(username.map(value => value: java.lang.String))(
        _.username
      )
      .optionallyWith(uid.map(value => value: java.lang.String))(_.uid)
      .optionallyWith(
        groups.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.groups)
      .build()
  }
  def asReadOnly: zio.aws.guardduty.model.KubernetesUserDetails.ReadOnly =
    zio.aws.guardduty.model.KubernetesUserDetails.wrap(buildAwsValue())
}
object KubernetesUserDetails {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.guardduty.model.KubernetesUserDetails
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.guardduty.model.KubernetesUserDetails =
      zio.aws.guardduty.model.KubernetesUserDetails(
        username.map(value => value),
        uid.map(value => value),
        groups.map(value => value)
      )
    def username: Optional[String]
    def uid: Optional[String]
    def groups: Optional[List[String]]
    def getUsername: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("username", username)
    def getUid: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("uid", uid)
    def getGroups: ZIO[Any, AwsError, List[String]] =
      AwsError.unwrapOptionField("groups", groups)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.guardduty.model.KubernetesUserDetails
  ) extends zio.aws.guardduty.model.KubernetesUserDetails.ReadOnly {
    override val username: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.username())
      .map(value => value: String)
    override val uid: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.uid())
      .map(value => value: String)
    override val groups: Optional[List[String]] = zio.aws.core.internal
      .optionalFromNullable(impl.groups())
      .map(value =>
        value.asScala.map { item =>
          item: String
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.guardduty.model.KubernetesUserDetails
  ): zio.aws.guardduty.model.KubernetesUserDetails.ReadOnly = new Wrapper(impl)
}
