package zio.aws.guardduty.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class KubernetesWorkloadDetails(
    name: Optional[String] = Optional.Absent,
    `type`: Optional[String] = Optional.Absent,
    uid: Optional[String] = Optional.Absent,
    namespace: Optional[String] = Optional.Absent,
    hostNetwork: Optional[Boolean] = Optional.Absent,
    containers: Optional[Iterable[zio.aws.guardduty.model.Container]] =
      Optional.Absent,
    volumes: Optional[Iterable[zio.aws.guardduty.model.Volume]] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.guardduty.model.KubernetesWorkloadDetails = {
    import KubernetesWorkloadDetails.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.guardduty.model.KubernetesWorkloadDetails
      .builder()
      .optionallyWith(name.map(value => value: java.lang.String))(_.name)
      .optionallyWith(`type`.map(value => value: java.lang.String))(_.`type`)
      .optionallyWith(uid.map(value => value: java.lang.String))(_.uid)
      .optionallyWith(namespace.map(value => value: java.lang.String))(
        _.namespace
      )
      .optionallyWith(hostNetwork.map(value => value: java.lang.Boolean))(
        _.hostNetwork
      )
      .optionallyWith(
        containers.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.containers)
      .optionallyWith(
        volumes.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.volumes)
      .build()
  }
  def asReadOnly: zio.aws.guardduty.model.KubernetesWorkloadDetails.ReadOnly =
    zio.aws.guardduty.model.KubernetesWorkloadDetails.wrap(buildAwsValue())
}
object KubernetesWorkloadDetails {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.guardduty.model.KubernetesWorkloadDetails
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.guardduty.model.KubernetesWorkloadDetails =
      zio.aws.guardduty.model.KubernetesWorkloadDetails(
        name.map(value => value),
        `type`.map(value => value),
        uid.map(value => value),
        namespace.map(value => value),
        hostNetwork.map(value => value),
        containers.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        volumes.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def name: Optional[String]
    def `type`: Optional[String]
    def uid: Optional[String]
    def namespace: Optional[String]
    def hostNetwork: Optional[Boolean]
    def containers: Optional[List[zio.aws.guardduty.model.Container.ReadOnly]]
    def volumes: Optional[List[zio.aws.guardduty.model.Volume.ReadOnly]]
    def getName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("name", name)
    def getType: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("type", `type`)
    def getUid: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("uid", uid)
    def getNamespace: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("namespace", namespace)
    def getHostNetwork: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("hostNetwork", hostNetwork)
    def getContainers
        : ZIO[Any, AwsError, List[zio.aws.guardduty.model.Container.ReadOnly]] =
      AwsError.unwrapOptionField("containers", containers)
    def getVolumes
        : ZIO[Any, AwsError, List[zio.aws.guardduty.model.Volume.ReadOnly]] =
      AwsError.unwrapOptionField("volumes", volumes)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.guardduty.model.KubernetesWorkloadDetails
  ) extends zio.aws.guardduty.model.KubernetesWorkloadDetails.ReadOnly {
    override val name: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.name())
      .map(value => value: String)
    override val `type`: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.`type`())
      .map(value => value: String)
    override val uid: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.uid())
      .map(value => value: String)
    override val namespace: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.namespace())
      .map(value => value: String)
    override val hostNetwork: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.hostNetwork())
      .map(value => value: Boolean)
    override val containers
        : Optional[List[zio.aws.guardduty.model.Container.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.containers())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.guardduty.model.Container.wrap(item)
          }.toList
        )
    override val volumes
        : Optional[List[zio.aws.guardduty.model.Volume.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.volumes())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.guardduty.model.Volume.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.guardduty.model.KubernetesWorkloadDetails
  ): zio.aws.guardduty.model.KubernetesWorkloadDetails.ReadOnly = new Wrapper(
    impl
  )
}
