package zio.aws.guardduty.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.guardduty.model.primitives.DetectorId
import scala.jdk.CollectionConverters.*
final case class ListDetectorsResponse(
    detectorIds: Iterable[DetectorId],
    nextToken: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.guardduty.model.ListDetectorsResponse = {
    import ListDetectorsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.guardduty.model.ListDetectorsResponse
      .builder()
      .detectorIds(detectorIds.map { item =>
        DetectorId.unwrap(item): java.lang.String
      }.asJavaCollection)
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .build()
  }
  def asReadOnly: zio.aws.guardduty.model.ListDetectorsResponse.ReadOnly =
    zio.aws.guardduty.model.ListDetectorsResponse.wrap(buildAwsValue())
}
object ListDetectorsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.guardduty.model.ListDetectorsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.guardduty.model.ListDetectorsResponse =
      zio.aws.guardduty.model
        .ListDetectorsResponse(detectorIds, nextToken.map(value => value))
    def detectorIds: List[DetectorId]
    def nextToken: Optional[String]
    def getDetectorIds: ZIO[Any, Nothing, List[DetectorId]] =
      ZIO.succeed(detectorIds)
    def getNextToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.guardduty.model.ListDetectorsResponse
  ) extends zio.aws.guardduty.model.ListDetectorsResponse.ReadOnly {
    override val detectorIds: List[DetectorId] = impl
      .detectorIds()
      .asScala
      .map { item =>
        zio.aws.guardduty.model.primitives.DetectorId(item)
      }
      .toList
    override val nextToken: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.guardduty.model.ListDetectorsResponse
  ): zio.aws.guardduty.model.ListDetectorsResponse.ReadOnly = new Wrapper(impl)
}
