package zio.aws.guardduty.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.guardduty.model.primitives.FilterName
import scala.jdk.CollectionConverters.*
final case class ListFiltersResponse(
    filterNames: Iterable[FilterName],
    nextToken: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.guardduty.model.ListFiltersResponse = {
    import ListFiltersResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.guardduty.model.ListFiltersResponse
      .builder()
      .filterNames(filterNames.map { item =>
        FilterName.unwrap(item): java.lang.String
      }.asJavaCollection)
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .build()
  }
  def asReadOnly: zio.aws.guardduty.model.ListFiltersResponse.ReadOnly =
    zio.aws.guardduty.model.ListFiltersResponse.wrap(buildAwsValue())
}
object ListFiltersResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.guardduty.model.ListFiltersResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.guardduty.model.ListFiltersResponse =
      zio.aws.guardduty.model
        .ListFiltersResponse(filterNames, nextToken.map(value => value))
    def filterNames: List[FilterName]
    def nextToken: Optional[String]
    def getFilterNames: ZIO[Any, Nothing, List[FilterName]] =
      ZIO.succeed(filterNames)
    def getNextToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.guardduty.model.ListFiltersResponse
  ) extends zio.aws.guardduty.model.ListFiltersResponse.ReadOnly {
    override val filterNames: List[FilterName] = impl
      .filterNames()
      .asScala
      .map { item =>
        zio.aws.guardduty.model.primitives.FilterName(item)
      }
      .toList
    override val nextToken: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.guardduty.model.ListFiltersResponse
  ): zio.aws.guardduty.model.ListFiltersResponse.ReadOnly = new Wrapper(impl)
}
