package zio.aws.guardduty.model
import zio.aws.guardduty.model.primitives.{MaxResults, DetectorId}
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters.*
final case class ListFindingsRequest(
    detectorId: DetectorId,
    findingCriteria: Optional[zio.aws.guardduty.model.FindingCriteria] =
      Optional.Absent,
    sortCriteria: Optional[zio.aws.guardduty.model.SortCriteria] =
      Optional.Absent,
    maxResults: Optional[MaxResults] = Optional.Absent,
    nextToken: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.guardduty.model.ListFindingsRequest = {
    import ListFindingsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.guardduty.model.ListFindingsRequest
      .builder()
      .detectorId(DetectorId.unwrap(detectorId): java.lang.String)
      .optionallyWith(findingCriteria.map(value => value.buildAwsValue()))(
        _.findingCriteria
      )
      .optionallyWith(sortCriteria.map(value => value.buildAwsValue()))(
        _.sortCriteria
      )
      .optionallyWith(
        maxResults.map(value => MaxResults.unwrap(value): Integer)
      )(_.maxResults)
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .build()
  }
  def asReadOnly: zio.aws.guardduty.model.ListFindingsRequest.ReadOnly =
    zio.aws.guardduty.model.ListFindingsRequest.wrap(buildAwsValue())
}
object ListFindingsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.guardduty.model.ListFindingsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.guardduty.model.ListFindingsRequest =
      zio.aws.guardduty.model.ListFindingsRequest(
        detectorId,
        findingCriteria.map(value => value.asEditable),
        sortCriteria.map(value => value.asEditable),
        maxResults.map(value => value),
        nextToken.map(value => value)
      )
    def detectorId: DetectorId
    def findingCriteria
        : Optional[zio.aws.guardduty.model.FindingCriteria.ReadOnly]
    def sortCriteria: Optional[zio.aws.guardduty.model.SortCriteria.ReadOnly]
    def maxResults: Optional[MaxResults]
    def nextToken: Optional[String]
    def getDetectorId: ZIO[Any, Nothing, DetectorId] = ZIO.succeed(detectorId)
    def getFindingCriteria
        : ZIO[Any, AwsError, zio.aws.guardduty.model.FindingCriteria.ReadOnly] =
      AwsError.unwrapOptionField("findingCriteria", findingCriteria)
    def getSortCriteria
        : ZIO[Any, AwsError, zio.aws.guardduty.model.SortCriteria.ReadOnly] =
      AwsError.unwrapOptionField("sortCriteria", sortCriteria)
    def getMaxResults: ZIO[Any, AwsError, MaxResults] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getNextToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.guardduty.model.ListFindingsRequest
  ) extends zio.aws.guardduty.model.ListFindingsRequest.ReadOnly {
    override val detectorId: DetectorId =
      zio.aws.guardduty.model.primitives.DetectorId(impl.detectorId())
    override val findingCriteria
        : Optional[zio.aws.guardduty.model.FindingCriteria.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.findingCriteria())
        .map(value => zio.aws.guardduty.model.FindingCriteria.wrap(value))
    override val sortCriteria
        : Optional[zio.aws.guardduty.model.SortCriteria.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.sortCriteria())
        .map(value => zio.aws.guardduty.model.SortCriteria.wrap(value))
    override val maxResults: Optional[MaxResults] = zio.aws.core.internal
      .optionalFromNullable(impl.maxResults())
      .map(value => zio.aws.guardduty.model.primitives.MaxResults(value))
    override val nextToken: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.guardduty.model.ListFindingsRequest
  ): zio.aws.guardduty.model.ListFindingsRequest.ReadOnly = new Wrapper(impl)
}
