package zio.aws.guardduty.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.guardduty.model.primitives.FindingId
import scala.jdk.CollectionConverters.*
final case class ListFindingsResponse(
    findingIds: Iterable[FindingId],
    nextToken: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.guardduty.model.ListFindingsResponse = {
    import ListFindingsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.guardduty.model.ListFindingsResponse
      .builder()
      .findingIds(findingIds.map { item =>
        FindingId.unwrap(item): java.lang.String
      }.asJavaCollection)
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .build()
  }
  def asReadOnly: zio.aws.guardduty.model.ListFindingsResponse.ReadOnly =
    zio.aws.guardduty.model.ListFindingsResponse.wrap(buildAwsValue())
}
object ListFindingsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.guardduty.model.ListFindingsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.guardduty.model.ListFindingsResponse =
      zio.aws.guardduty.model
        .ListFindingsResponse(findingIds, nextToken.map(value => value))
    def findingIds: List[FindingId]
    def nextToken: Optional[String]
    def getFindingIds: ZIO[Any, Nothing, List[FindingId]] =
      ZIO.succeed(findingIds)
    def getNextToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.guardduty.model.ListFindingsResponse
  ) extends zio.aws.guardduty.model.ListFindingsResponse.ReadOnly {
    override val findingIds: List[FindingId] = impl
      .findingIds()
      .asScala
      .map { item =>
        zio.aws.guardduty.model.primitives.FindingId(item)
      }
      .toList
    override val nextToken: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.guardduty.model.ListFindingsResponse
  ): zio.aws.guardduty.model.ListFindingsResponse.ReadOnly = new Wrapper(impl)
}
